/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class StreamConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ScalingPolicy scalingPolicy;
    private final RetentionPolicy retentionPolicy;
    private final long timestampAggregationTimeout;

    @ConstructorProperties(value={"scalingPolicy", "retentionPolicy", "timestampAggregationTimeout"})
    @SuppressFBWarnings(justification="generated code")
    StreamConfiguration(ScalingPolicy scalingPolicy, RetentionPolicy retentionPolicy, long timestampAggregationTimeout) {
        this.scalingPolicy = scalingPolicy;
        this.retentionPolicy = retentionPolicy;
        this.timestampAggregationTimeout = timestampAggregationTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamConfigurationBuilder builder() {
        return new StreamConfigurationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTimestampAggregationTimeout() {
        return this.timestampAggregationTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamConfiguration)) {
            return false;
        }
        StreamConfiguration other = (StreamConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScalingPolicy this$scalingPolicy = this.getScalingPolicy();
        ScalingPolicy other$scalingPolicy = other.getScalingPolicy();
        if (this$scalingPolicy == null ? other$scalingPolicy != null : !((Object)this$scalingPolicy).equals(other$scalingPolicy)) {
            return false;
        }
        RetentionPolicy this$retentionPolicy = this.getRetentionPolicy();
        RetentionPolicy other$retentionPolicy = other.getRetentionPolicy();
        if (this$retentionPolicy == null ? other$retentionPolicy != null : !((Object)this$retentionPolicy).equals(other$retentionPolicy)) {
            return false;
        }
        return this.getTimestampAggregationTimeout() == other.getTimestampAggregationTimeout();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScalingPolicy $scalingPolicy = this.getScalingPolicy();
        result = result * 59 + ($scalingPolicy == null ? 43 : ((Object)$scalingPolicy).hashCode());
        RetentionPolicy $retentionPolicy = this.getRetentionPolicy();
        result = result * 59 + ($retentionPolicy == null ? 43 : ((Object)$retentionPolicy).hashCode());
        long $timestampAggregationTimeout = this.getTimestampAggregationTimeout();
        result = result * 59 + (int)($timestampAggregationTimeout >>> 32 ^ $timestampAggregationTimeout);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StreamConfiguration(scalingPolicy=" + this.getScalingPolicy() + ", retentionPolicy=" + this.getRetentionPolicy() + ", timestampAggregationTimeout=" + this.getTimestampAggregationTimeout() + ")";
    }

    public static final class StreamConfigurationBuilder {
        @SuppressFBWarnings(justification="generated code")
        private RetentionPolicy retentionPolicy;
        @SuppressFBWarnings(justification="generated code")
        private long timestampAggregationTimeout;
        private ScalingPolicy scalingPolicy = ScalingPolicy.fixed(1);

        @Deprecated
        public StreamConfigurationBuilder scope(String scope) {
            return this;
        }

        @Deprecated
        public StreamConfigurationBuilder streamName(String streamName) {
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        StreamConfigurationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationBuilder scalingPolicy(ScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationBuilder retentionPolicy(RetentionPolicy retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationBuilder timestampAggregationTimeout(long timestampAggregationTimeout) {
            this.timestampAggregationTimeout = timestampAggregationTimeout;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfiguration build() {
            return new StreamConfiguration(this.scalingPolicy, this.retentionPolicy, this.timestampAggregationTimeout);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamConfiguration.StreamConfigurationBuilder(scalingPolicy=" + this.scalingPolicy + ", retentionPolicy=" + this.retentionPolicy + ", timestampAggregationTimeout=" + this.timestampAggregationTimeout + ")";
        }
    }
}

