/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import io.pravega.common.concurrent.Futures;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CancellableRequest<T> {
    private final AtomicBoolean done;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicReference<T> result;
    private final AtomicReference<CompletableFuture<T>> futureRef;
    private final CompletableFuture<Void> started;

    public CancellableRequest() {
        this.done = new AtomicBoolean(false);
        this.result = new AtomicReference();
        this.futureRef = new AtomicReference<Object>(null);
        this.started = new CompletableFuture();
    }

    public void cancel() {
        this.cancelled.set(true);
        this.futureRef.updateAndGet(future -> {
            if (future != null) {
                future.cancel(true);
            }
            return future;
        });
    }

    public void start(Supplier<CompletableFuture<T>> supplier, Predicate<T> termination, ScheduledExecutorService executor) {
        this.futureRef.updateAndGet(previous -> {
            if (previous != null) {
                throw new IllegalStateException("Request already started");
            }
            return Futures.loop(() -> !this.done.get() && !this.cancelled.get(), () -> this.lambda$null$4((Supplier)supplier, termination, executor), (Executor)executor).thenApply(v -> {
                if (this.done.get()) {
                    return this.result.get();
                }
                throw new CancellationException();
            });
        });
        this.started.complete(null);
    }

    public CompletableFuture<T> getFuture() {
        return this.started.thenCompose(x -> this.futureRef.get());
    }

    private /* synthetic */ CompletableFuture lambda$null$4(Supplier supplier, Predicate termination, ScheduledExecutorService executor) {
        return Futures.delayedFuture(() -> this.lambda$null$3((Supplier)supplier, termination), (long)1000L, (ScheduledExecutorService)executor);
    }

    private /* synthetic */ CompletableFuture lambda$null$3(Supplier supplier, Predicate termination) {
        return ((CompletableFuture)supplier.get()).thenAccept(r -> {
            this.result.set(r);
            this.done.set(termination.test(r));
        });
    }
}

