/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Checkpoint;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.StreamCutImpl;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CheckpointImpl
implements Checkpoint {
    private static final CheckpointSerializer SERIALIZER = new CheckpointSerializer();
    private final String name;
    private final Map<Stream, StreamCut> positions;

    CheckpointImpl(String name, Map<Segment, Long> segmentPositions) {
        this.name = name;
        HashMap<Stream, ImmutableMap.Builder> streamPositions = new HashMap<Stream, ImmutableMap.Builder>();
        for (Map.Entry<Segment, Long> position : segmentPositions.entrySet()) {
            streamPositions.computeIfAbsent(position.getKey().getStream(), k -> new ImmutableMap.Builder()).put(position);
        }
        ImmutableMap.Builder positionBuilder = ImmutableMap.builder();
        for (Map.Entry streamPosition : streamPositions.entrySet()) {
            positionBuilder.put(streamPosition.getKey(), (Object)new StreamCutImpl((Stream)streamPosition.getKey(), (Map<Segment, Long>)((ImmutableMap.Builder)streamPosition.getValue()).build()));
        }
        this.positions = positionBuilder.build();
    }

    private CheckpointImpl(Map<Stream, StreamCut> positions, String name) {
        this.name = name;
        this.positions = positions;
    }

    @Override
    public CheckpointImpl asImpl() {
        return this;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static Checkpoint fromBytes(ByteBuffer buff) {
        return (Checkpoint)SERIALIZER.deserialize((ArrayView)new ByteArraySegment(buff));
    }

    @SuppressFBWarnings(justification="generated code")
    public static CheckpointBuilder builder() {
        return new CheckpointBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointImpl)) {
            return false;
        }
        CheckpointImpl other = (CheckpointImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<Stream, StreamCut> this$positions = this.getPositions();
        Map<Stream, StreamCut> other$positions = other.getPositions();
        return !(this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof CheckpointImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<Stream, StreamCut> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        return result;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    public Map<Stream, StreamCut> getPositions() {
        return this.positions;
    }

    private static class CheckpointSerializer
    extends VersionedSerializer.WithBuilder<CheckpointImpl, CheckpointBuilder> {
        private CheckpointSerializer() {
        }

        protected CheckpointBuilder newBuilder() {
            return CheckpointImpl.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, CheckpointBuilder builder) throws IOException {
            builder.name(revisionDataInput.readUTF());
            Map map = revisionDataInput.readMap(in -> Stream.of(in.readUTF()), arg_0 -> ((StreamCutImpl.StreamCutSerializer)StreamCutImpl.SERIALIZER).deserialize(arg_0));
            builder.positions(map);
        }

        private void write00(CheckpointImpl checkpoint, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(checkpoint.getName());
            Map<Stream, StreamCut> map = checkpoint.getPositions();
            revisionDataOutput.writeMap(map, (out, s) -> out.writeUTF(s.getScopedName()), (out, cut) -> StreamCutImpl.SERIALIZER.serialize(out, cut.asImpl()));
        }
    }

    private static class CheckpointBuilder
    implements ObjectBuilder<CheckpointImpl> {
        @SuppressFBWarnings(justification="generated code")
        private Map<Stream, StreamCut> positions;
        @SuppressFBWarnings(justification="generated code")
        private String name;

        @SuppressFBWarnings(justification="generated code")
        CheckpointBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public CheckpointBuilder positions(Map<Stream, StreamCut> positions) {
            this.positions = positions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CheckpointBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CheckpointImpl build() {
            return new CheckpointImpl(this.positions, this.name);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "CheckpointImpl.CheckpointBuilder(positions=" + this.positions + ", name=" + this.name + ")";
        }
    }
}

