/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.impl.CancellableRequest;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.client.stream.impl.TxnSegments;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.common.util.AsyncIterator;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public interface Controller
extends AutoCloseable {
    public CompletableFuture<Boolean> createScope(String var1);

    public AsyncIterator<Stream> listStreams(String var1);

    public CompletableFuture<Boolean> deleteScope(String var1);

    public CompletableFuture<Boolean> createStream(String var1, String var2, StreamConfiguration var3);

    public CompletableFuture<Boolean> updateStream(String var1, String var2, StreamConfiguration var3);

    public CompletableFuture<Boolean> truncateStream(String var1, String var2, StreamCut var3);

    public CompletableFuture<Boolean> sealStream(String var1, String var2);

    public CompletableFuture<Boolean> deleteStream(String var1, String var2);

    public CompletableFuture<Boolean> startScale(Stream var1, List<Long> var2, Map<Double, Double> var3);

    public CancellableRequest<Boolean> scaleStream(Stream var1, List<Long> var2, Map<Double, Double> var3, ScheduledExecutorService var4);

    public CompletableFuture<Boolean> checkScaleStatus(Stream var1, int var2);

    public CompletableFuture<StreamSegments> getCurrentSegments(String var1, String var2);

    public CompletableFuture<TxnSegments> createTransaction(Stream var1, long var2);

    public CompletableFuture<Transaction.PingStatus> pingTransaction(Stream var1, UUID var2, long var3);

    public CompletableFuture<Void> commitTransaction(Stream var1, String var2, Long var3, UUID var4);

    public CompletableFuture<Void> abortTransaction(Stream var1, UUID var2);

    public CompletableFuture<Transaction.Status> checkTransactionStatus(Stream var1, UUID var2);

    public CompletableFuture<Map<Segment, Long>> getSegmentsAtTime(Stream var1, long var2);

    public CompletableFuture<StreamSegmentsWithPredecessors> getSuccessors(Segment var1);

    public CompletableFuture<StreamSegmentSuccessors> getSuccessors(StreamCut var1);

    public CompletableFuture<StreamSegmentSuccessors> getSegments(StreamCut var1, StreamCut var2);

    public CompletableFuture<Boolean> isSegmentOpen(Segment var1);

    public CompletableFuture<PravegaNodeUri> getEndpointForSegment(String var1);

    public CompletableFuture<Void> noteTimestampFromWriter(String var1, Stream var2, long var3, WriterPosition var5);

    public CompletableFuture<Void> removeWriter(String var1, Stream var2);

    @Override
    public void close();

    public CompletableFuture<String> getOrRefreshDelegationTokenFor(String var1, String var2);
}

