/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class ControllerImplConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;
    private final ClientConfig clientConfig;

    @ConstructorProperties(value={"initialBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple", "clientConfig"})
    @SuppressFBWarnings(justification="generated code")
    ControllerImplConfig(int initialBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple, ClientConfig clientConfig) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
        this.clientConfig = clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public static ControllerImplConfigBuilder builder() {
        return new ControllerImplConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerImplConfig)) {
            return false;
        }
        ControllerImplConfig other = (ControllerImplConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getBackoffMultiple() != other.getBackoffMultiple()) {
            return false;
        }
        ClientConfig this$clientConfig = this.getClientConfig();
        ClientConfig other$clientConfig = other.getClientConfig();
        return !(this$clientConfig == null ? other$clientConfig != null : !((Object)this$clientConfig).equals(other$clientConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ControllerImplConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        ClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : ((Object)$clientConfig).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ControllerImplConfig(initialBackoffMillis=" + this.getInitialBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ", clientConfig=" + this.getClientConfig() + ")";
    }

    public static final class ControllerImplConfigBuilder {
        @SuppressFBWarnings(justification="generated code")
        private ClientConfig clientConfig;
        private int initialBackoffMillis = 1;
        private int maxBackoffMillis = 20000;
        private int retryAttempts = 10;
        private int backoffMultiple = 10;
        private ClientConfig config = ClientConfig.builder().controllerURI(null).credentials(null).trustStore("").build();

        @SuppressFBWarnings(justification="generated code")
        ControllerImplConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfigBuilder initialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfigBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfigBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfigBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfigBuilder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ControllerImplConfig build() {
            return new ControllerImplConfig(this.initialBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple, this.clientConfig);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ControllerImplConfig.ControllerImplConfigBuilder(initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ", clientConfig=" + this.clientConfig + ")";
        }
    }
}

