/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.NoSuchEventException;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.stream.EventPointer;
import io.pravega.client.stream.EventRead;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.Position;
import io.pravega.client.stream.ReaderConfig;
import io.pravega.client.stream.ReaderNotInReaderGroupException;
import io.pravega.client.stream.ReinitializationRequiredException;
import io.pravega.client.stream.Sequence;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.TimeWindow;
import io.pravega.client.stream.TruncatedDataException;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.EventPointerImpl;
import io.pravega.client.stream.impl.EventReadImpl;
import io.pravega.client.stream.impl.Orderer;
import io.pravega.client.stream.impl.PositionImpl;
import io.pravega.client.stream.impl.PositionInternal;
import io.pravega.client.stream.impl.ReaderGroupStateManager;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.WatermarkReaderImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamReaderImpl<Type>
implements EventStreamReader<Type> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(EventStreamReaderImpl.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final long BASE_READER_WAITING_TIME_MS = 10L;
    private final Serializer<Type> deserializer;
    private final SegmentInputStreamFactory inputStreamFactory;
    private final SegmentMetadataClientFactory metadataClientFactory;
    private final Orderer orderer;
    private final ReaderConfig config;
    private final ImmutableMap<Stream, WatermarkReaderImpl> waterMarkReaders;
    @GuardedBy(value="readers")
    private boolean closed;
    @GuardedBy(value="readers")
    private final List<EventSegmentReader> readers = new ArrayList<EventSegmentReader>();
    @GuardedBy(value="readers")
    private final Map<Segment, SegmentWithRange.Range> ranges = new HashMap<Segment, SegmentWithRange.Range>();
    @GuardedBy(value="readers")
    private final Map<SegmentWithRange, Long> sealedSegments = new HashMap<SegmentWithRange, Long>();
    @GuardedBy(value="readers")
    private Sequence lastRead;
    @GuardedBy(value="readers")
    private String atCheckpoint;
    private final ReaderGroupStateManager groupState;
    private final Supplier<Long> clock;
    private final Controller controller;

    EventStreamReaderImpl(SegmentInputStreamFactory inputStreamFactory, SegmentMetadataClientFactory metadataClientFactory, Serializer<Type> deserializer, ReaderGroupStateManager groupState, Orderer orderer, Supplier<Long> clock, ReaderConfig config, ImmutableMap<Stream, WatermarkReaderImpl> waterMarkReaders, Controller controller) {
        this.deserializer = deserializer;
        this.inputStreamFactory = inputStreamFactory;
        this.metadataClientFactory = metadataClientFactory;
        this.groupState = groupState;
        this.orderer = orderer;
        this.clock = clock;
        this.config = config;
        this.waterMarkReaders = waterMarkReaders;
        this.closed = false;
        this.controller = controller;
    }

    @Override
    public EventRead<Type> readNextEvent(long timeout) throws ReinitializationRequiredException, TruncatedDataException {
        List<EventSegmentReader> list = this.readers;
        synchronized (list) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Reader is closed");
            try {
                return this.readNextEventInternal(timeout);
            }
            catch (ReaderNotInReaderGroupException e) {
                this.close();
                throw new ReinitializationRequiredException(e);
            }
        }
    }

    private EventRead<Type> readNextEventInternal(long timeout) throws ReaderNotInReaderGroupException, TruncatedDataException {
        ByteBuffer buffer;
        long waitTime = Math.min(timeout, 10L);
        Timer timer = new Timer();
        Segment segment = null;
        long offset = -1L;
        do {
            String checkpoint;
            if ((checkpoint = this.updateGroupStateIfNeeded()) != null) {
                return this.createEmptyEvent(checkpoint);
            }
            EventSegmentReader segmentReader = this.orderer.nextSegment(this.readers);
            if (segmentReader == null) {
                Exceptions.handleInterrupted(() -> Thread.sleep(waitTime));
                buffer = null;
                continue;
            }
            segment = segmentReader.getSegmentId();
            offset = segmentReader.getOffset();
            try {
                buffer = segmentReader.read(waitTime);
            }
            catch (EndOfSegmentException e) {
                boolean isSegmentSealed = e.getErrorType().equals((Object)EndOfSegmentException.ErrorType.END_OF_SEGMENT_REACHED);
                this.handleEndOfSegment(segmentReader, isSegmentSealed);
                buffer = null;
            }
            catch (SegmentTruncatedException e) {
                this.handleSegmentTruncated(segmentReader);
                buffer = null;
            }
        } while (buffer == null && timer.getElapsedMillis() < timeout);
        if (buffer == null) {
            return this.createEmptyEvent(null);
        }
        this.lastRead = Sequence.create(segment.getSegmentId(), offset);
        int length = buffer.remaining() + 8;
        return new EventReadImpl<Type>(this.deserializer.deserialize(buffer), this.getPosition(), new EventPointerImpl(segment, offset, length), null);
    }

    private EventRead<Type> createEmptyEvent(String checkpoint) {
        return new EventReadImpl<Object>(null, this.getPosition(), null, checkpoint);
    }

    private PositionInternal getPosition() {
        Map<SegmentWithRange, Long> positions = this.readers.stream().collect(Collectors.toMap(e -> new SegmentWithRange(e.getSegmentId(), this.ranges.get(e.getSegmentId())), e -> e.getOffset()));
        this.sealedSegments.forEach((key, value) -> positions.put((SegmentWithRange)key, -1L));
        return new PositionImpl(positions);
    }

    @GuardedBy(value="readers")
    private String updateGroupStateIfNeeded() throws ReaderNotInReaderGroupException {
        String checkpoint;
        PositionInternal position = this.getPosition();
        if (this.atCheckpoint != null) {
            this.groupState.checkpoint(this.atCheckpoint, position);
            log.info("Reader {} completed checkpoint {}", (Object)this.groupState.getReaderId(), (Object)this.atCheckpoint);
            this.releaseSegmentsIfNeeded(position);
        }
        if ((checkpoint = this.groupState.getCheckpoint()) != null) {
            log.info("{} at checkpoint {}", (Object)this, (Object)checkpoint);
            if (this.groupState.isCheckpointSilent(checkpoint)) {
                this.groupState.checkpoint(checkpoint, position);
                if (this.atCheckpoint != null) {
                    this.releaseSegmentsIfNeeded(position);
                    this.atCheckpoint = null;
                }
                return null;
            }
            this.atCheckpoint = checkpoint;
            return this.atCheckpoint;
        }
        this.atCheckpoint = null;
        if (this.acquireSegmentsIfNeeded(position) || this.groupState.updateLagIfNeeded(this.getLag(), position)) {
            this.waterMarkReaders.forEach((stream, reader) -> reader.advanceTo(this.groupState.getLastReadpositions((Stream)stream)));
        }
        return null;
    }

    @GuardedBy(value="readers")
    private void releaseSegmentsIfNeeded(PositionInternal position) throws ReaderNotInReaderGroupException {
        this.releaseSealedSegments();
        Segment segment = this.groupState.findSegmentToReleaseIfRequired();
        if (segment != null) {
            log.info("{} releasing segment {}", (Object)this, (Object)segment);
            EventSegmentReader reader = this.readers.stream().filter(r -> r.getSegmentId().equals(segment)).findAny().orElse(null);
            if (reader != null && this.groupState.releaseSegment(segment, reader.getOffset(), this.getLag(), position)) {
                this.readers.remove(reader);
                this.ranges.remove(reader.getSegmentId());
                reader.close();
            }
        }
    }

    private void releaseSealedSegments() throws ReaderNotInReaderGroupException {
        SegmentWithRange oldSegment;
        Iterator<Map.Entry<SegmentWithRange, Long>> iterator = this.sealedSegments.entrySet().iterator();
        while (iterator.hasNext() && this.groupState.handleEndOfSegment(oldSegment = iterator.next().getKey())) {
            iterator.remove();
        }
    }

    @GuardedBy(value="readers")
    private boolean acquireSegmentsIfNeeded(PositionInternal position) throws ReaderNotInReaderGroupException {
        Map<SegmentWithRange, Long> newSegments = this.groupState.acquireNewSegmentsIfNeeded(this.getLag(), position);
        if (!newSegments.isEmpty()) {
            log.info("{} acquiring segments {}", (Object)this, newSegments);
            for (Map.Entry<SegmentWithRange, Long> newSegment : newSegments.entrySet()) {
                long endOffset = this.groupState.getEndOffsetForSegment(newSegment.getKey().getSegment());
                if (newSegment.getValue() < 0L || newSegment.getValue() == endOffset && endOffset != Long.MAX_VALUE) {
                    this.sealedSegments.put(newSegment.getKey(), newSegment.getValue());
                    continue;
                }
                Segment segment = newSegment.getKey().getSegment();
                EventSegmentReader in = this.inputStreamFactory.createEventReaderForSegment(segment, endOffset);
                in.setOffset(newSegment.getValue());
                this.readers.add(in);
                this.ranges.put(segment, newSegment.getKey().getRange());
            }
            return true;
        }
        return false;
    }

    private long getLag() {
        if (this.lastRead == null) {
            return 0L;
        }
        return this.clock.get() - this.lastRead.getHighOrder();
    }

    @GuardedBy(value="readers")
    private void handleEndOfSegment(EventSegmentReader oldSegment, boolean segmentSealed) {
        Segment segmentId = oldSegment.getSegmentId();
        log.info("{} encountered end of segment {} ", (Object)this, (Object)oldSegment.getSegmentId());
        this.readers.remove(oldSegment);
        SegmentWithRange.Range range = this.ranges.remove(segmentId);
        oldSegment.close();
        this.sealedSegments.put(new SegmentWithRange(segmentId, range), segmentSealed ? -1L : oldSegment.getOffset());
    }

    private void handleSegmentTruncated(EventSegmentReader segmentReader) throws TruncatedDataException {
        Segment segmentId = segmentReader.getSegmentId();
        log.info("{} encountered truncation for segment {} ", (Object)this, (Object)segmentId);
        SegmentMetadataClient metadataClient = this.metadataClientFactory.createSegmentMetadataClient(segmentId, DelegationTokenProviderFactory.create(this.controller, segmentId));
        try {
            try {
                long startingOffset = metadataClient.getSegmentInfo().getStartingOffset();
                segmentReader.setOffset(startingOffset);
            }
            catch (NoSuchSegmentException e) {
                this.handleEndOfSegment(segmentReader, true);
            }
            throw new TruncatedDataException();
        }
        catch (Throwable throwable) {
            if (Collections.singletonList(metadataClient).get(0) != null) {
                metadataClient.close();
            }
            throw throwable;
        }
    }

    @Override
    public ReaderConfig getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        this.closeAt(this.getPosition());
        for (WatermarkReaderImpl reader : this.waterMarkReaders.values()) {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAt(Position position) {
        List<EventSegmentReader> list = this.readers;
        synchronized (list) {
            if (!this.closed) {
                log.info("Closing reader {} at position {}.", (Object)this, (Object)position);
                this.closed = true;
                this.groupState.readerShutdown(position);
                for (EventSegmentReader reader : this.readers) {
                    reader.close();
                }
                this.readers.clear();
                this.ranges.clear();
                this.groupState.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Type fetchEvent(EventPointer pointer) throws NoSuchEventException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<EventSegmentReader> getReaders() {
        Object object = this.$lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.readers);
        }
    }

    public String toString() {
        return "EventStreamReaderImpl( id=" + this.groupState.getReaderId() + ")";
    }

    @Override
    public TimeWindow getCurrentTimeWindow(Stream stream) {
        if (this.getConfig().isDisableTimeWindows()) {
            return new TimeWindow(null, null);
        }
        WatermarkReaderImpl tracker = (WatermarkReaderImpl)this.waterMarkReaders.get((Object)stream);
        if (tracker == null) {
            throw new IllegalArgumentException("Reader is not subscribed to stream: " + stream);
        }
        return tracker.getTimeWindow();
    }
}

