/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.notifications.NotificationSystem;
import io.pravega.client.stream.notifications.notifier.EndOfDataNotifier;
import io.pravega.client.stream.notifications.notifier.SegmentNotifier;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;

public class NotifierFactory {
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private final NotificationSystem system;
    @GuardedBy(value="$lock")
    private StateSynchronizer<ReaderGroupState> synchronizer;
    @GuardedBy(value="$lock")
    private SegmentNotifier segmentNotifier;
    @GuardedBy(value="$lock")
    private EndOfDataNotifier endOfDataNotifier;

    public NotifierFactory(NotificationSystem notificationSystem, StateSynchronizer<ReaderGroupState> synchronizer) {
        this.system = notificationSystem;
        this.synchronizer = synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentNotifier getSegmentNotifier(ScheduledExecutorService executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.segmentNotifier == null) {
                this.segmentNotifier = new SegmentNotifier(this.system, this.synchronizer, executor);
            }
            return this.segmentNotifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndOfDataNotifier getEndOfDataNotifier(ScheduledExecutorService executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.endOfDataNotifier == null) {
                this.endOfDataNotifier = new EndOfDataNotifier(this.system, this.synchronizer, executor);
            }
            return this.endOfDataNotifier;
        }
    }
}

