/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.RequestProcessor;
import io.pravega.shared.protocol.netty.WireCommands;
import java.util.UUID;

public class Append
implements Request,
Comparable<Append> {
    final String segment;
    final UUID writerId;
    final long eventNumber;
    final int eventCount;
    final ByteBuf data;
    final Long expectedLength;
    final long flowId;

    public Append(String segment, UUID writerId, long eventNumber, WireCommands.Event event, long flowId) {
        this(segment, writerId, eventNumber, 1, event.getAsByteBuf(), null, flowId);
    }

    public Append(String segment, UUID writerId, long eventNumber, WireCommands.Event event, long expectedLength, long flowId) {
        this(segment, writerId, eventNumber, 1, event.getAsByteBuf(), expectedLength, flowId);
    }

    public Append(String segment, UUID writerId, long eventNumber, int eventCount, ByteBuf data, Long expectedLength, long flowId) {
        this.segment = segment;
        this.writerId = writerId;
        this.eventNumber = eventNumber;
        this.eventCount = eventCount;
        this.data = data;
        this.expectedLength = expectedLength;
        this.flowId = flowId;
    }

    public int getDataLength() {
        return this.data.readableBytes();
    }

    public boolean isConditional() {
        return this.expectedLength != null;
    }

    @Override
    public void process(RequestProcessor cp) {
        cp.append(this);
    }

    @Override
    public int compareTo(Append other) {
        return Long.compare(this.eventNumber, other.eventNumber);
    }

    @Override
    public long getRequestId() {
        return this.flowId;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getSegment() {
        return this.segment;
    }

    @SuppressFBWarnings(justification="generated code")
    public UUID getWriterId() {
        return this.writerId;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getEventNumber() {
        return this.eventNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getEventCount() {
        return this.eventCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public ByteBuf getData() {
        return this.data;
    }

    @SuppressFBWarnings(justification="generated code")
    public Long getExpectedLength() {
        return this.expectedLength;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getFlowId() {
        return this.flowId;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Append)) {
            return false;
        }
        Append other = (Append)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$segment = this.getSegment();
        String other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
            return false;
        }
        UUID this$writerId = this.getWriterId();
        UUID other$writerId = other.getWriterId();
        if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
            return false;
        }
        if (this.getEventNumber() != other.getEventNumber()) {
            return false;
        }
        if (this.getEventCount() != other.getEventCount()) {
            return false;
        }
        ByteBuf this$data = this.getData();
        ByteBuf other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Long this$expectedLength = this.getExpectedLength();
        Long other$expectedLength = other.getExpectedLength();
        if (this$expectedLength == null ? other$expectedLength != null : !((Object)this$expectedLength).equals(other$expectedLength)) {
            return false;
        }
        return this.getFlowId() == other.getFlowId();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Append;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
        UUID $writerId = this.getWriterId();
        result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
        long $eventNumber = this.getEventNumber();
        result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
        result = result * 59 + this.getEventCount();
        ByteBuf $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Long $expectedLength = this.getExpectedLength();
        result = result * 59 + ($expectedLength == null ? 43 : ((Object)$expectedLength).hashCode());
        long $flowId = this.getFlowId();
        result = result * 59 + (int)($flowId >>> 32 ^ $flowId);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Append(segment=" + this.getSegment() + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", eventCount=" + this.getEventCount() + ", data=" + this.getData() + ", expectedLength=" + this.getExpectedLength() + ", flowId=" + this.getFlowId() + ")";
    }
}

