/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.pravega.common.io.EnhancedByteArrayOutputStream;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shared.protocol.netty.Append;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendDecoder
extends MessageToMessageDecoder<WireCommand> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(AppendDecoder.class);
    private final HashMap<UUID, Segment> appendingSegments = new HashMap();
    private WireCommands.AppendBlock currentBlock;

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof WireCommands.SetupAppend || msg instanceof WireCommands.AppendBlock || msg instanceof WireCommands.AppendBlockEnd || msg instanceof WireCommands.Padding || msg instanceof WireCommands.ConditionalAppend;
    }

    protected void decode(ChannelHandlerContext ctx, WireCommand command, List<Object> out) throws Exception {
        Request result = this.processCommand(command);
        if (result != null) {
            out.add(result);
        }
    }

    @VisibleForTesting
    public Request processCommand(WireCommand command) throws Exception {
        Request result;
        if (this.currentBlock != null && command.getType() != WireCommandType.APPEND_BLOCK_END) {
            log.warn("Invalid message received {}. CurrentBlock {}", (Object)command, (Object)this.currentBlock);
            throw new InvalidMessageException("Unexpected " + (Object)((Object)command.getType()) + " following a append block.");
        }
        switch (command.getType()) {
            case PADDING: {
                result = null;
                break;
            }
            case SETUP_APPEND: {
                WireCommands.SetupAppend append = (WireCommands.SetupAppend)command;
                this.appendingSegments.put(append.getWriterId(), new Segment(append.getSegment()));
                result = append;
                break;
            }
            case CONDITIONAL_APPEND: {
                WireCommands.ConditionalAppend ca = (WireCommands.ConditionalAppend)command;
                Segment segment = this.getSegment(ca.getWriterId());
                if (ca.getEventNumber() < segment.lastEventNumber) {
                    throw new InvalidMessageException("Last event number went backwards.");
                }
                segment.lastEventNumber = ca.getEventNumber();
                EnhancedByteArrayOutputStream bout = new EnhancedByteArrayOutputStream();
                ca.getEvent().writeFields(new DataOutputStream((OutputStream)bout));
                ByteArraySegment data = bout.getData();
                result = new Append(segment.getName(), ca.getWriterId(), ca.getEventNumber(), 1, Unpooled.wrappedBuffer((byte[])data.array(), (int)data.arrayOffset(), (int)data.getLength()), ca.getExpectedOffset(), ca.getRequestId());
                break;
            }
            case APPEND_BLOCK: {
                this.currentBlock = (WireCommands.AppendBlock)command;
                this.getSegment(this.currentBlock.getWriterId());
                result = null;
                break;
            }
            case APPEND_BLOCK_END: {
                ByteBuf appendDataBuf;
                WireCommands.AppendBlockEnd blockEnd = (WireCommands.AppendBlockEnd)command;
                UUID writerId = blockEnd.getWriterId();
                Segment segment = this.getSegment(writerId);
                int sizeOfWholeEventsInBlock = blockEnd.getSizeOfWholeEvents();
                if (blockEnd.numEvents <= 0) {
                    throw new InvalidMessageException("Invalid number of events in block. numEvents : " + blockEnd.numEvents);
                }
                if (blockEnd.getLastEventNumber() < segment.lastEventNumber) {
                    throw new InvalidMessageException(String.format("Last event number went backwards, Segment last Event number : %d , Append block End Event number : %d,for writer ID: %s and Segment Name: %s", segment.lastEventNumber, blockEnd.getLastEventNumber(), writerId, segment.name));
                }
                if (this.currentBlock != null) {
                    if (!this.currentBlock.getWriterId().equals(writerId)) {
                        throw new InvalidMessageException(String.format("Writer ID mismatch between Append Block and Append block End, Append block Writer ID : %s, Append block End Writer ID: %s", this.currentBlock.getWriterId(), writerId));
                    }
                    if (sizeOfWholeEventsInBlock > this.currentBlock.getData().readableBytes() || sizeOfWholeEventsInBlock < 0) {
                        throw new InvalidMessageException(String.format("Invalid SizeOfWholeEvents in block : %d, Append block data bytes : %d", sizeOfWholeEventsInBlock, this.currentBlock.getData().readableBytes()));
                    }
                    appendDataBuf = this.getAppendDataBuf(blockEnd, sizeOfWholeEventsInBlock);
                } else {
                    appendDataBuf = blockEnd.getData();
                }
                if (appendDataBuf == null) {
                    throw new InvalidMessageException("Invalid data in block");
                }
                segment.lastEventNumber = blockEnd.getLastEventNumber();
                this.currentBlock = null;
                result = new Append(segment.name, writerId, segment.lastEventNumber, blockEnd.numEvents, appendDataBuf, null, blockEnd.getRequestId());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case: " + command);
            }
        }
        return result;
    }

    private ByteBuf getAppendDataBuf(WireCommands.AppendBlockEnd blockEnd, int sizeOfWholeEventsInBlock) throws IOException {
        ByteBuf appendDataBuf = this.currentBlock.getData().slice(0, sizeOfWholeEventsInBlock);
        int remaining = this.currentBlock.getData().readableBytes() - sizeOfWholeEventsInBlock;
        if (remaining > 0) {
            ByteBuf dataRemainingInBlock = this.currentBlock.getData().slice(sizeOfWholeEventsInBlock, remaining);
            WireCommand cmd = CommandDecoder.parseCommand(dataRemainingInBlock);
            if (cmd.getType() != WireCommandType.PARTIAL_EVENT && cmd.getType() != WireCommandType.PADDING) {
                throw new InvalidMessageException("Found " + (Object)((Object)cmd.getType()) + " at end of append block but was expecting a partialEvent or padding.");
            }
            if (cmd.getType() == WireCommandType.PADDING && blockEnd.getData().readableBytes() != 0) {
                throw new InvalidMessageException("Unexpected data in BlockEnd");
            }
            if (cmd.getType() == WireCommandType.PARTIAL_EVENT) {
                if (appendDataBuf.readableBytes() == 0) {
                    appendDataBuf.release();
                    appendDataBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{((WireCommands.PartialEvent)cmd).getData(), blockEnd.getData()});
                } else {
                    appendDataBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{appendDataBuf, ((WireCommands.PartialEvent)cmd).getData(), blockEnd.getData()});
                }
            }
        }
        ByteBuf result = appendDataBuf.copy();
        appendDataBuf.release();
        return result;
    }

    private Segment getSegment(UUID writerId) {
        Segment segment = this.appendingSegments.get(writerId);
        if (segment == null) {
            throw new InvalidMessageException("ConnectionID refrenced before SetupAppend");
        }
        return segment;
    }

    private static final class Segment {
        private final String name;
        private long lastEventNumber;

        @ConstructorProperties(value={"name"})
        @SuppressFBWarnings(justification="generated code")
        public Segment(String name) {
            this.name = name;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setLastEventNumber(long lastEventNumber) {
            this.lastEventNumber = lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLastEventNumber() == other.getLastEventNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "AppendDecoder.Segment(name=" + this.getName() + ", lastEventNumber=" + this.getLastEventNumber() + ")";
        }
    }
}

