/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.pravega.common.Exceptions;
import io.pravega.common.util.BufferView;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;

@NotThreadSafe
public class ByteBufWrapper
implements BufferView {
    private final ByteBuf buf;

    public ByteBufWrapper(@NonNull ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf is marked @NonNull but is null");
        }
        this.buf = buf.asReadOnly();
    }

    public void retain() {
        this.buf.retain();
    }

    public void release() {
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    public int getLength() {
        return this.buf.readableBytes();
    }

    public InputStream getReader() {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)this);
        return new ByteBufInputStream(this.buf.duplicate(), false);
    }

    public byte[] getCopy() {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)this);
        ByteBuf buf = this.buf.duplicate();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    public void copyTo(OutputStream target) throws IOException {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)this);
        ByteBuf buf = this.buf.duplicate();
        buf.readBytes(target, buf.readableBytes());
    }

    public String toString() {
        return this.buf.toString();
    }
}

