/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.watermarks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shared.watermarks.SegmentWithRange;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class Watermark {
    public static final WatermarkSerializer SERIALIZER = new WatermarkSerializer();
    public static final Watermark EMPTY = new Watermark(Long.MIN_VALUE, Long.MIN_VALUE, (Map<SegmentWithRange, Long>)ImmutableMap.of());
    private final long lowerTimeBound;
    private final long upperTimeBound;
    private final Map<SegmentWithRange, Long> streamCut;

    public Watermark(long lowerTimeBound, long upperTimeBound, Map<SegmentWithRange, Long> streamCut) {
        Preconditions.checkArgument((upperTimeBound >= lowerTimeBound ? 1 : 0) != 0);
        this.lowerTimeBound = lowerTimeBound;
        this.upperTimeBound = upperTimeBound;
        this.streamCut = streamCut;
    }

    public static Watermark fromByteBuf(ByteBuffer data) {
        return (Watermark)SERIALIZER.deserialize((ArrayView)new ByteArraySegment(data));
    }

    public ByteBuffer toByteBuf() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    @SuppressFBWarnings(justification="generated code")
    public static WatermarkBuilder builder() {
        return new WatermarkBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public long getLowerTimeBound() {
        return this.lowerTimeBound;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getUpperTimeBound() {
        return this.upperTimeBound;
    }

    @SuppressFBWarnings(justification="generated code")
    public Map<SegmentWithRange, Long> getStreamCut() {
        return this.streamCut;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Watermark)) {
            return false;
        }
        Watermark other = (Watermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLowerTimeBound() != other.getLowerTimeBound()) {
            return false;
        }
        if (this.getUpperTimeBound() != other.getUpperTimeBound()) {
            return false;
        }
        Map<SegmentWithRange, Long> this$streamCut = this.getStreamCut();
        Map<SegmentWithRange, Long> other$streamCut = other.getStreamCut();
        return !(this$streamCut == null ? other$streamCut != null : !((Object)this$streamCut).equals(other$streamCut));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Watermark;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lowerTimeBound = this.getLowerTimeBound();
        result = result * 59 + (int)($lowerTimeBound >>> 32 ^ $lowerTimeBound);
        long $upperTimeBound = this.getUpperTimeBound();
        result = result * 59 + (int)($upperTimeBound >>> 32 ^ $upperTimeBound);
        Map<SegmentWithRange, Long> $streamCut = this.getStreamCut();
        result = result * 59 + ($streamCut == null ? 43 : ((Object)$streamCut).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Watermark(lowerTimeBound=" + this.getLowerTimeBound() + ", upperTimeBound=" + this.getUpperTimeBound() + ", streamCut=" + this.getStreamCut() + ")";
    }

    private static class WatermarkSerializer
    extends VersionedSerializer.WithBuilder<Watermark, WatermarkBuilder> {
        private WatermarkSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, WatermarkBuilder builder) throws IOException {
            builder.lowerTimeBound(revisionDataInput.readLong());
            builder.upperTimeBound(revisionDataInput.readLong());
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(arg_0 -> ((SegmentWithRange.SegmentWithRangeSerializer)SegmentWithRange.SERIALIZER).deserialize(arg_0), DataInput::readLong, mapBuilder);
            builder.streamCut((Map<SegmentWithRange, Long>)mapBuilder.build());
        }

        private void write00(Watermark watermark, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(watermark.lowerTimeBound);
            revisionDataOutput.writeLong(watermark.upperTimeBound);
            revisionDataOutput.writeMap(watermark.streamCut, (arg_0, arg_1) -> ((SegmentWithRange.SegmentWithRangeSerializer)SegmentWithRange.SERIALIZER).serialize(arg_0, arg_1), DataOutput::writeLong);
        }

        protected WatermarkBuilder newBuilder() {
            return Watermark.builder();
        }
    }

    public static class WatermarkBuilder
    implements ObjectBuilder<Watermark> {
        @SuppressFBWarnings(justification="generated code")
        private long lowerTimeBound;
        @SuppressFBWarnings(justification="generated code")
        private long upperTimeBound;
        @SuppressFBWarnings(justification="generated code")
        private Map<SegmentWithRange, Long> streamCut;

        @SuppressFBWarnings(justification="generated code")
        WatermarkBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public WatermarkBuilder lowerTimeBound(long lowerTimeBound) {
            this.lowerTimeBound = lowerTimeBound;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WatermarkBuilder upperTimeBound(long upperTimeBound) {
            this.upperTimeBound = upperTimeBound;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WatermarkBuilder streamCut(Map<SegmentWithRange, Long> streamCut) {
            this.streamCut = streamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Watermark build() {
            return new Watermark(this.lowerTimeBound, this.upperTimeBound, this.streamCut);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "Watermark.WatermarkBuilder(lowerTimeBound=" + this.lowerTimeBound + ", upperTimeBound=" + this.upperTimeBound + ", streamCut=" + this.streamCut + ")";
        }
    }
}

