/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class AutoScaleEvent
implements ControllerEvent {
    public static final byte UP = 0;
    public static final byte DOWN = 1;
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final long segmentId;
    private final byte direction;
    private final long timestamp;
    private final int numOfSplits;
    private final boolean silent;
    private final long requestId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return processor.processAutoScaleRequest(this);
    }

    public String toString() {
        return String.format("%s/%s/%s, Direction=%d, Splits=%d", this.scope, this.stream, this.segmentId, this.direction, this.numOfSplits);
    }

    @SuppressFBWarnings(justification="generated code")
    public static AutoScaleEventBuilder builder() {
        return new AutoScaleEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSegmentId() {
        return this.segmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    public byte getDirection() {
        return this.direction;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTimestamp() {
        return this.timestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getNumOfSplits() {
        return this.numOfSplits;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSilent() {
        return this.silent;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoScaleEvent)) {
            return false;
        }
        AutoScaleEvent other = (AutoScaleEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        if (this.getSegmentId() != other.getSegmentId()) {
            return false;
        }
        if (this.getDirection() != other.getDirection()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getNumOfSplits() != other.getNumOfSplits()) {
            return false;
        }
        if (this.isSilent() != other.isSilent()) {
            return false;
        }
        return this.getRequestId() == other.getRequestId();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof AutoScaleEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        long $segmentId = this.getSegmentId();
        result = result * 59 + (int)($segmentId >>> 32 ^ $segmentId);
        result = result * 59 + this.getDirection();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getNumOfSplits();
        result = result * 59 + (this.isSilent() ? 79 : 97);
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        return result;
    }

    @ConstructorProperties(value={"scope", "stream", "segmentId", "direction", "timestamp", "numOfSplits", "silent", "requestId"})
    @SuppressFBWarnings(justification="generated code")
    public AutoScaleEvent(String scope, String stream, long segmentId, byte direction, long timestamp, int numOfSplits, boolean silent, long requestId) {
        this.scope = scope;
        this.stream = stream;
        this.segmentId = segmentId;
        this.direction = direction;
        this.timestamp = timestamp;
        this.numOfSplits = numOfSplits;
        this.silent = silent;
        this.requestId = requestId;
    }

    static class Serializer
    extends VersionedSerializer.WithBuilder<AutoScaleEvent, AutoScaleEventBuilder> {
        Serializer() {
        }

        protected AutoScaleEventBuilder newBuilder() {
            return AutoScaleEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(AutoScaleEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeLong(e.segmentId);
            target.writeByte((int)e.direction);
            target.writeLong(e.timestamp);
            target.writeCompactInt(e.numOfSplits);
            target.writeBoolean(e.silent);
            target.writeLong(e.requestId);
        }

        private void read00(RevisionDataInput source, AutoScaleEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.segmentId(source.readLong());
            b.direction(source.readByte());
            b.timestamp(source.readLong());
            b.numOfSplits(source.readCompactInt());
            b.silent(source.readBoolean());
            b.requestId(source.readLong());
        }
    }

    private static class AutoScaleEventBuilder
    implements ObjectBuilder<AutoScaleEvent> {
        @SuppressFBWarnings(justification="generated code")
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        private long segmentId;
        @SuppressFBWarnings(justification="generated code")
        private byte direction;
        @SuppressFBWarnings(justification="generated code")
        private long timestamp;
        @SuppressFBWarnings(justification="generated code")
        private int numOfSplits;
        @SuppressFBWarnings(justification="generated code")
        private boolean silent;
        @SuppressFBWarnings(justification="generated code")
        private long requestId;

        @SuppressFBWarnings(justification="generated code")
        AutoScaleEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder segmentId(long segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder direction(byte direction) {
            this.direction = direction;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder numOfSplits(int numOfSplits) {
            this.numOfSplits = numOfSplits;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public AutoScaleEvent build() {
            return new AutoScaleEvent(this.scope, this.stream, this.segmentId, this.direction, this.timestamp, this.numOfSplits, this.silent, this.requestId);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "AutoScaleEvent.AutoScaleEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", segmentId=" + this.segmentId + ", direction=" + this.direction + ", timestamp=" + this.timestamp + ", numOfSplits=" + this.numOfSplits + ", silent=" + this.silent + ", requestId=" + this.requestId + ")";
        }
    }
}

