/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.tracing;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.pravega.common.tracing.RequestTag;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.common.tracing.TagLogger;
import org.slf4j.LoggerFactory;

public final class RPCTracingHelpers {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(RPCTracingHelpers.class));
    private static final String REQUEST_DESCRIPTOR = "requestDescriptor";
    private static final String REQUEST_ID = "requestId";
    public static final CallOptions.Key<String> REQUEST_DESCRIPTOR_CALL_OPTION = CallOptions.Key.createWithDefault((String)"requestDescriptor", (Object)"");
    public static final CallOptions.Key<String> REQUEST_ID_CALL_OPTION = CallOptions.Key.createWithDefault((String)"requestId", (Object)"");
    static final Metadata.Key<String> DESCRIPTOR_HEADER = Metadata.Key.of((String)"requestDescriptor", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> ID_HEADER = Metadata.Key.of((String)"requestId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static ClientInterceptor getClientInterceptor() {
        return new TaggingClientInterceptor();
    }

    public static ServerInterceptor getServerInterceptor(RequestTracker requestTracker) {
        return new TaggingServerInterceptor(requestTracker);
    }

    private static class TaggingServerInterceptor
    implements ServerInterceptor {
        private final RequestTracker requestTracker;

        public TaggingServerInterceptor(RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            if (headers != null && headers.containsKey(DESCRIPTOR_HEADER) && headers.containsKey(ID_HEADER)) {
                RequestTag requestTag = new RequestTag((String)headers.get(DESCRIPTOR_HEADER), Long.parseLong((String)headers.get(ID_HEADER)));
                this.requestTracker.trackRequest(requestTag);
                log.debug(requestTag.getRequestId(), "Received tag from RPC request {}.", new Object[]{requestTag.getRequestDescriptor()});
            } else {
                log.debug("No tags provided for call {} in headers: {}.", (Object)call.getMethodDescriptor().getFullMethodName(), (Object)headers);
            }
            return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void sendHeaders(Metadata responseHeaders) {
                    super.sendHeaders(responseHeaders);
                }
            }, headers);
        }
    }

    private static class TaggingClientInterceptor
    implements ClientInterceptor {
        private TaggingClientInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    String requestDescriptor = (String)callOptions.getOption(REQUEST_DESCRIPTOR_CALL_OPTION);
                    String requestId = (String)callOptions.getOption(REQUEST_ID_CALL_OPTION);
                    if (requestDescriptor != null && requestId != null && !requestDescriptor.isEmpty() && !requestId.isEmpty()) {
                        headers.put(DESCRIPTOR_HEADER, (Object)requestDescriptor);
                        headers.put(ID_HEADER, (Object)requestId);
                        log.debug(Long.parseLong(requestId), "Tagging RPC request {}.", new Object[]{requestDescriptor});
                    } else {
                        log.debug("Request not tagged {}: Call options not containing request tags.", (Object)method.getFullMethodName());
                    }
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onHeaders(Metadata headers) {
                            super.onHeaders(headers);
                        }
                    }, headers);
                }
            };
        }
    }
}

