/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.publisher.RhsPadding;
import io.micrometer.shaded.reactor.core.publisher.RingBuffer;
import io.micrometer.shaded.reactor.core.publisher.Value;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongSupplier;

final class AtomicSequence
extends RhsPadding
implements LongSupplier,
RingBuffer.Sequence {
    private static final AtomicLongFieldUpdater<Value> UPDATER = AtomicLongFieldUpdater.newUpdater(Value.class, "value");

    AtomicSequence(long initialValue) {
        UPDATER.lazySet(this, initialValue);
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public void set(long value) {
        UPDATER.set(this, value);
    }

    @Override
    public boolean compareAndSet(long expectedValue, long newValue) {
        return UPDATER.compareAndSet(this, expectedValue, newValue);
    }
}

