/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.FluxMetrics;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoMetrics;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.function.Tuple2;
import java.util.List;

final class MonoMetricsFuseable<T>
extends MonoOperator<T, T>
implements Fuseable {
    final String name;
    final List<Tag> tags;
    @Nullable
    final MeterRegistry registryCandidate;

    MonoMetricsFuseable(Mono<? extends T> mono) {
        this(mono, null);
    }

    MonoMetricsFuseable(Mono<? extends T> mono, @Nullable MeterRegistry registryCandidate) {
        super(mono);
        Tuple2<String, List<Tag>> nameAndTags = FluxMetrics.resolveNameAndTags(mono);
        this.name = nameAndTags.getT1();
        this.tags = nameAndTags.getT2();
        this.registryCandidate = registryCandidate;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        CompositeMeterRegistry registry = Metrics.globalRegistry;
        if (this.registryCandidate != null) {
            registry = this.registryCandidate;
        }
        this.source.subscribe(new MonoMetrics.MicrometerMonoMetricsFuseableSubscriber<T>(actual, (MeterRegistry)registry, Clock.SYSTEM, this.name, this.tags));
    }
}

