/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.http.HttpProtocol;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.http.client.HttpResponseDecoderSpec;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class HttpClientConfiguration {
    static final HttpClientConfiguration DEFAULT = new HttpClientConfiguration();
    static final AttributeKey<HttpClientConfiguration> CONF_KEY = AttributeKey.newInstance("httpClientConf");
    boolean acceptGzip = false;
    Boolean chunkedTransfer = null;
    String uri = null;
    String baseUrl = null;
    HttpHeaders headers = null;
    HttpMethod method = HttpMethod.GET;
    String websocketSubprotocols = null;
    int websocketMaxFramePayloadLength = 65536;
    int protocols = 4;
    HttpResponseDecoderSpec decoder = new HttpResponseDecoderSpec();
    ClientCookieEncoder cookieEncoder = ClientCookieEncoder.STRICT;
    ClientCookieDecoder cookieDecoder = ClientCookieDecoder.STRICT;
    BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate = null;
    Function<Mono<HttpClientConfiguration>, Mono<HttpClientConfiguration>> deferredConf = null;
    BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> body;
    static final Function<Bootstrap, Bootstrap> MAP_KEEPALIVE = b -> {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        if (c.headers == null) {
            return b;
        }
        HttpUtil.setKeepAlive(c.headers, HttpVersion.HTTP_1_1, true);
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_KEEPALIVE = b -> {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        if (c.headers == null) {
            c.headers = new DefaultHttpHeaders();
        }
        HttpUtil.setKeepAlive(c.headers, HttpVersion.HTTP_1_1, false);
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_COMPRESS = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).acceptGzip = true;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_COMPRESS = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).acceptGzip = false;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_CHUNKED = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).chunkedTransfer = true;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_CHUNKED = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).chunkedTransfer = false;
        return b;
    };
    static final Pattern FOLLOW_REDIRECT_CODES = Pattern.compile("30[1278]");
    static final BiPredicate<HttpClientRequest, HttpClientResponse> FOLLOW_REDIRECT_PREDICATE = (req, res) -> FOLLOW_REDIRECT_CODES.matcher(res.status().codeAsText()).matches();
    static final Function<Bootstrap, Bootstrap> MAP_REDIRECT = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).followRedirectPredicate = FOLLOW_REDIRECT_PREDICATE;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_REDIRECT = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).followRedirectPredicate = null;
        return b;
    };
    static final int h11 = 4;
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11orH2c = 5;

    HttpClientConfiguration() {
    }

    HttpClientConfiguration(HttpClientConfiguration from) {
        this.uri = from.uri;
        this.acceptGzip = from.acceptGzip;
        this.cookieEncoder = from.cookieEncoder;
        this.cookieDecoder = from.cookieDecoder;
        this.decoder = from.decoder;
        this.followRedirectPredicate = from.followRedirectPredicate;
        this.chunkedTransfer = from.chunkedTransfer;
        this.baseUrl = from.baseUrl;
        this.headers = from.headers;
        this.method = from.method;
        this.websocketSubprotocols = from.websocketSubprotocols;
        this.websocketMaxFramePayloadLength = from.websocketMaxFramePayloadLength;
        this.body = from.body;
        this.protocols = from.protocols;
        this.deferredConf = from.deferredConf;
    }

    static HttpClientConfiguration getAndClean(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        b.attr(CONF_KEY, null);
        if (hcc == null) {
            hcc = DEFAULT;
        }
        return hcc;
    }

    static HttpClientConfiguration getOrCreate(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            hcc = new HttpClientConfiguration();
            b.attr(CONF_KEY, hcc);
        }
        return hcc;
    }

    static HttpClientConfiguration get(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            return DEFAULT;
        }
        return hcc;
    }

    static Bootstrap uri(Bootstrap b, String uri) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).uri = uri;
        return b;
    }

    HttpClientConfiguration uri(String uri) {
        this.uri = uri;
        return this;
    }

    static Bootstrap baseUrl(Bootstrap b, String baseUrl) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).baseUrl = baseUrl;
        return b;
    }

    static Bootstrap deferredConf(Bootstrap b, Function<HttpClientConfiguration, Mono<HttpClientConfiguration>> deferrer) {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        c.deferredConf = c.deferredConf != null ? c.deferredConf.andThen(deferredConf -> deferredConf.flatMap(deferrer)) : deferredConf -> deferredConf.flatMap(deferrer);
        return b;
    }

    static Bootstrap headers(Bootstrap b, HttpHeaders headers) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).headers = headers;
        return b;
    }

    HttpClientConfiguration headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Nullable
    static HttpHeaders headers(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            return null;
        }
        return hcc.headers;
    }

    static Bootstrap method(Bootstrap b, HttpMethod method) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).method = method;
        return b;
    }

    static Bootstrap body(Bootstrap b, BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> body) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).body = body;
        return b;
    }

    static Bootstrap protocols(Bootstrap b, HttpProtocol ... protocols) {
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p != HttpProtocol.H2C) continue;
            _protocols |= 1;
        }
        HttpClientConfiguration.getOrCreate((Bootstrap)b).protocols = _protocols;
        return b;
    }

    static Bootstrap websocketSubprotocols(Bootstrap b, String websocketSubprotocols) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).websocketSubprotocols = websocketSubprotocols;
        return b;
    }

    static Bootstrap websocketMaxFramePayloadLength(Bootstrap b, int websocketMaxFramePayloadLength) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).websocketMaxFramePayloadLength = websocketMaxFramePayloadLength;
        return b;
    }

    static Bootstrap cookieCodec(Bootstrap b, ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        HttpClientConfiguration conf = HttpClientConfiguration.getOrCreate(b);
        conf.cookieEncoder = encoder;
        conf.cookieDecoder = decoder;
        return b;
    }

    static Bootstrap followRedirectPredicate(Bootstrap b, BiPredicate<HttpClientRequest, HttpClientResponse> predicate) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).followRedirectPredicate = predicate;
        return b;
    }

    static Bootstrap decoder(Bootstrap b, HttpResponseDecoderSpec decoder) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).decoder = decoder;
        return b;
    }
}

