/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.InvalidPropertyValueException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;

public class BookKeeperConfig {
    public static final Property<String> ZK_ADDRESS = Property.named((String)"zkAddress", (Object)"localhost:2181");
    public static final Property<Integer> ZK_SESSION_TIMEOUT = Property.named((String)"zkSessionTimeoutMillis", (Object)10000);
    public static final Property<Integer> ZK_CONNECTION_TIMEOUT = Property.named((String)"zkConnectionTimeoutMillis", (Object)10000);
    public static final Property<String> ZK_METADATA_PATH = Property.named((String)"zkMetadataPath", (Object)"/segmentstore/containers");
    public static final Property<Integer> ZK_HIERARCHY_DEPTH = Property.named((String)"zkHierarchyDepth", (Object)2);
    public static final Property<Integer> MAX_WRITE_ATTEMPTS = Property.named((String)"maxWriteAttempts", (Object)5);
    public static final Property<Integer> BK_ENSEMBLE_SIZE = Property.named((String)"bkEnsembleSize", (Object)3);
    public static final Property<Integer> BK_ACK_QUORUM_SIZE = Property.named((String)"bkAckQuorumSize", (Object)2);
    public static final Property<Integer> BK_WRITE_QUORUM_SIZE = Property.named((String)"bkWriteQuorumSize", (Object)3);
    public static final Property<Integer> BK_WRITE_TIMEOUT = Property.named((String)"bkWriteTimeoutMillis", (Object)60000);
    public static final Property<Integer> BK_READ_TIMEOUT = Property.named((String)"readTimeoutMillis", (Object)30000);
    public static final Property<Integer> MAX_OUTSTANDING_BYTES = Property.named((String)"maxOutstandingBytes", (Object)0x10000000);
    public static final Property<Integer> BK_LEDGER_MAX_SIZE = Property.named((String)"bkLedgerMaxSize", (Object)0x40000000);
    public static final Property<String> BK_PASSWORD = Property.named((String)"bkPass", (Object)"");
    public static final Property<String> BK_LEDGER_PATH = Property.named((String)"bkLedgerPath", (Object)"");
    public static final Property<Boolean> BK_TLS_ENABLED = Property.named((String)"tlsEnabled", (Object)false);
    public static final Property<String> TLS_TRUST_STORE_PATH = Property.named((String)"tlsTrustStorePath", (Object)"config/client.truststore.jks");
    public static final Property<String> TLS_TRUST_STORE_PASSWORD_PATH = Property.named((String)"tlsTrustStorePasswordPath", (Object)"");
    public static final String COMPONENT_CODE = "bookkeeper";
    static final int MAX_APPEND_LENGTH = 1047552;
    private final String zkAddress;
    private final Duration zkSessionTimeout;
    private final Duration zkConnectionTimeout;
    private final String zkMetadataPath;
    private final int zkHierarchyDepth;
    private final int maxWriteAttempts;
    private final String bkLedgerPath;
    private final int bkEnsembleSize;
    private final int bkAckQuorumSize;
    private final int bkWriteQuorumSize;
    private final int bkWriteTimeoutMillis;
    private final int bkReadTimeoutMillis;
    private final int maxOutstandingBytes;
    private final int bkLedgerMaxSize;
    private final byte[] bkPassword;
    private final boolean isTLSEnabled;
    private final String tlsTrustStore;
    private final String tlsTrustStorePasswordPath;

    private BookKeeperConfig(TypedProperties properties) throws ConfigurationException {
        this.zkAddress = properties.get(ZK_ADDRESS).replace(",", ";");
        this.zkSessionTimeout = Duration.ofMillis(properties.getInt(ZK_SESSION_TIMEOUT));
        this.zkConnectionTimeout = Duration.ofMillis(properties.getInt(ZK_CONNECTION_TIMEOUT));
        this.zkMetadataPath = properties.get(ZK_METADATA_PATH);
        this.zkHierarchyDepth = properties.getInt(ZK_HIERARCHY_DEPTH);
        if (this.zkHierarchyDepth < 0) {
            throw new InvalidPropertyValueException(String.format("Property %s (%d) must be a non-negative integer.", ZK_HIERARCHY_DEPTH, this.zkHierarchyDepth));
        }
        this.maxWriteAttempts = properties.getInt(MAX_WRITE_ATTEMPTS);
        this.bkLedgerPath = properties.get(BK_LEDGER_PATH);
        this.bkEnsembleSize = properties.getInt(BK_ENSEMBLE_SIZE);
        this.bkAckQuorumSize = properties.getInt(BK_ACK_QUORUM_SIZE);
        this.bkWriteQuorumSize = properties.getInt(BK_WRITE_QUORUM_SIZE);
        if (this.bkWriteQuorumSize < this.bkAckQuorumSize) {
            throw new InvalidPropertyValueException(String.format("Property %s (%d) must be greater than or equal to %s (%d).", BK_WRITE_QUORUM_SIZE, this.bkWriteQuorumSize, BK_ACK_QUORUM_SIZE, this.bkAckQuorumSize));
        }
        this.bkWriteTimeoutMillis = properties.getInt(BK_WRITE_TIMEOUT);
        this.bkReadTimeoutMillis = properties.getInt(BK_READ_TIMEOUT);
        this.maxOutstandingBytes = properties.getInt(MAX_OUTSTANDING_BYTES);
        this.bkLedgerMaxSize = properties.getInt(BK_LEDGER_MAX_SIZE);
        this.bkPassword = properties.get(BK_PASSWORD).getBytes(StandardCharsets.UTF_8);
        this.isTLSEnabled = properties.getBoolean(BK_TLS_ENABLED);
        this.tlsTrustStore = properties.get(TLS_TRUST_STORE_PATH);
        this.tlsTrustStorePasswordPath = properties.get(TLS_TRUST_STORE_PASSWORD_PATH);
    }

    byte[] getBKPassword() {
        return Arrays.copyOf(this.bkPassword, this.bkPassword.length);
    }

    public static ConfigBuilder<BookKeeperConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, BookKeeperConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getZkAddress() {
        return this.zkAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getZkMetadataPath() {
        return this.zkMetadataPath;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getZkHierarchyDepth() {
        return this.zkHierarchyDepth;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxWriteAttempts() {
        return this.maxWriteAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getBkLedgerPath() {
        return this.bkLedgerPath;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkEnsembleSize() {
        return this.bkEnsembleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkAckQuorumSize() {
        return this.bkAckQuorumSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkWriteQuorumSize() {
        return this.bkWriteQuorumSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkWriteTimeoutMillis() {
        return this.bkWriteTimeoutMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkReadTimeoutMillis() {
        return this.bkReadTimeoutMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxOutstandingBytes() {
        return this.maxOutstandingBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBkLedgerMaxSize() {
        return this.bkLedgerMaxSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isTLSEnabled() {
        return this.isTLSEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getTlsTrustStorePasswordPath() {
        return this.tlsTrustStorePasswordPath;
    }
}

