/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Timer;
import io.pravega.common.util.ArrayView;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.WriteLedger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class Write {
    final ArrayView data;
    private final CompletableFuture<LogAddress> result;
    private final AtomicInteger attemptCount;
    private final AtomicReference<WriteLedger> writeLedger;
    private final AtomicLong entryId;
    private final AtomicReference<Timer> beginAttemptTimer;
    private final AtomicReference<Throwable> failureCause;
    private long queueAddedTimestamp;

    Write(ArrayView data, WriteLedger initialWriteLedger, CompletableFuture<LogAddress> result) {
        this.data = (ArrayView)Preconditions.checkNotNull((Object)data, (Object)"data");
        this.writeLedger = new AtomicReference<Object>(Preconditions.checkNotNull((Object)initialWriteLedger, (Object)"initialWriteLedger"));
        this.result = (CompletableFuture)Preconditions.checkNotNull(result, (Object)"result");
        this.attemptCount = new AtomicInteger();
        this.failureCause = new AtomicReference();
        this.entryId = new AtomicLong(Long.MIN_VALUE);
        this.beginAttemptTimer = new AtomicReference();
    }

    WriteLedger getWriteLedger() {
        return this.writeLedger.get();
    }

    void setWriteLedger(WriteLedger writeLedger) {
        this.writeLedger.set(writeLedger);
        this.entryId.set(Long.MIN_VALUE);
    }

    void setEntryId(long value) {
        this.entryId.set(value);
    }

    long getEntryId() {
        return this.entryId.get();
    }

    int beginAttempt() {
        Preconditions.checkState((boolean)this.beginAttemptTimer.compareAndSet(null, new Timer()), (Object)"Write already in progress. Cannot restart.");
        return this.attemptCount.incrementAndGet();
    }

    private Timer endAttempt() {
        return this.beginAttemptTimer.getAndSet(null);
    }

    boolean isInProgress() {
        return this.beginAttemptTimer.get() != null;
    }

    boolean isDone() {
        return this.result.isDone();
    }

    Throwable getFailureCause() {
        return this.failureCause.get();
    }

    Timer complete() {
        Preconditions.checkState((this.entryId.get() >= 0L ? 1 : 0) != 0, (Object)"entryId not set; cannot complete Write.");
        this.failureCause.set(null);
        this.result.complete(new LedgerAddress(this.writeLedger.get().metadata, this.entryId.get()));
        return this.endAttempt();
    }

    void fail(Throwable cause, boolean complete) {
        if (cause != null) {
            Throwable e = this.failureCause.get();
            if (e != null && e != cause) {
                cause.addSuppressed(e);
            }
            this.failureCause.set(cause);
        }
        this.endAttempt();
        WriteLedger ledger = this.writeLedger.get();
        if (ledger != null && ledger.isRolledOver()) {
            this.attemptCount.updateAndGet(v -> Math.max(0, v - 1));
        }
        if (complete) {
            this.result.completeExceptionally(this.failureCause.get());
        }
    }

    public String toString() {
        return String.format("LedgerId = %s, Length = %s, Attempts = %s, InProgress = %s, Done = %s, Failed %s", this.writeLedger.get().metadata.getLedgerId(), this.data.getLength(), this.attemptCount, this.isInProgress(), this.isDone(), this.failureCause.get() != null);
    }

    @SuppressFBWarnings(justification="generated code")
    public long getQueueAddedTimestamp() {
        return this.queueAddedTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQueueAddedTimestamp(long queueAddedTimestamp) {
        this.queueAddedTimestamp = queueAddedTimestamp;
    }
}

