/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.impl.bookkeeper.Write;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class WriteQueue {
    private final Supplier<Long> timeSupplier;
    @GuardedBy(value="this")
    private final Deque<Write> writes;
    @GuardedBy(value="this")
    private long totalLength;
    @GuardedBy(value="this")
    private int lastDurationMillis;
    @GuardedBy(value="this")
    private boolean closed;

    WriteQueue() {
        this(System::nanoTime);
    }

    @VisibleForTesting
    WriteQueue(Supplier<Long> timeSupplier) {
        this.timeSupplier = (Supplier)Preconditions.checkNotNull(timeSupplier, (Object)"timeSupplier");
        this.writes = new ArrayDeque<Write>();
    }

    synchronized QueueStats getStatistics() {
        int size = this.writes.size();
        double fillRatio = WriteQueue.calculateFillRatio(this.totalLength, size);
        int processingTime = this.lastDurationMillis;
        if (processingTime == 0 && size > 0) {
            processingTime = (int)((this.timeSupplier.get() - this.writes.peekFirst().getQueueAddedTimestamp()) / 1000000L);
        }
        return new QueueStats(size, fillRatio, processingTime);
    }

    synchronized void add(Write write) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        this.writes.addLast(write);
        this.totalLength += (long)write.data.getLength();
        write.setQueueAddedTimestamp(this.timeSupplier.get());
    }

    synchronized List<Write> close() {
        ArrayList<Write> items = new ArrayList<Write>(this.writes);
        this.writes.clear();
        this.totalLength = 0L;
        this.closed = true;
        return items;
    }

    synchronized List<Write> getWritesToExecute(long maximumAccumulatedSize) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        long accumulatedSize = 0L;
        long firstLedgerId = this.writes.peekFirst().getWriteLedger().metadata.getLedgerId();
        boolean canSkip = true;
        ArrayList<Write> result = new ArrayList<Write>();
        for (Write write : this.writes) {
            if (accumulatedSize >= maximumAccumulatedSize) break;
            accumulatedSize += (long)write.data.getLength();
            if (write.isInProgress()) {
                if (canSkip) continue;
                return Collections.emptyList();
            }
            if (write.getWriteLedger().metadata.getLedgerId() != firstLedgerId) break;
            if (write.isDone()) continue;
            canSkip = false;
            result.add(write);
        }
        return result;
    }

    synchronized CleanupResult removeFinishedWrites() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        long currentTime = this.timeSupplier.get();
        long totalElapsed = 0L;
        int removedCount = 0;
        boolean failedWrite = false;
        while (!this.writes.isEmpty() && this.writes.peekFirst().isDone()) {
            Write w = this.writes.removeFirst();
            this.totalLength = Math.max(0L, this.totalLength - (long)w.data.getLength());
            ++removedCount;
            totalElapsed += currentTime - w.getQueueAddedTimestamp();
            failedWrite |= w.getFailureCause() != null;
        }
        if (removedCount > 0) {
            this.lastDurationMillis = (int)(totalElapsed / (long)removedCount / 1000000L);
        }
        CleanupStatus status = failedWrite ? CleanupStatus.WriteFailed : (this.writes.isEmpty() ? CleanupStatus.QueueEmpty : CleanupStatus.QueueNotEmpty);
        return new CleanupResult(status, removedCount);
    }

    private static double calculateFillRatio(long totalLength, int size) {
        if (size > 0) {
            return Math.min(1.0, (double)totalLength / (double)size / 1047552.0);
        }
        return 0.0;
    }

    @SuppressFBWarnings(justification="generated code")
    public Supplier<Long> getTimeSupplier() {
        return this.timeSupplier;
    }

    static enum CleanupStatus {
        QueueEmpty,
        QueueNotEmpty,
        WriteFailed;

    }

    static class CleanupResult {
        private final CleanupStatus status;
        private final int removedCount;

        @ConstructorProperties(value={"status", "removedCount"})
        @SuppressFBWarnings(justification="generated code")
        private CleanupResult(CleanupStatus status, int removedCount) {
            this.status = status;
            this.removedCount = removedCount;
        }

        @SuppressFBWarnings(justification="generated code")
        public CleanupStatus getStatus() {
            return this.status;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getRemovedCount() {
            return this.removedCount;
        }
    }
}

