/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import java.io.InputStream;

public interface SyncStorage
extends AutoCloseable {
    public void initialize(long var1);

    public SegmentHandle openRead(String var1) throws StreamSegmentException;

    public int read(SegmentHandle var1, long var2, byte[] var4, int var5, int var6) throws StreamSegmentException;

    public SegmentProperties getStreamSegmentInfo(String var1) throws StreamSegmentException;

    public boolean exists(String var1);

    public SegmentHandle openWrite(String var1) throws StreamSegmentException;

    public SegmentHandle create(String var1) throws StreamSegmentException;

    default public SegmentHandle create(String streamSegmentName, SegmentRollingPolicy rollingPolicy) throws StreamSegmentException {
        return this.create(streamSegmentName);
    }

    public void delete(SegmentHandle var1) throws StreamSegmentException;

    public void write(SegmentHandle var1, long var2, InputStream var4, int var5) throws StreamSegmentException;

    public void seal(SegmentHandle var1) throws StreamSegmentException;

    public void unseal(SegmentHandle var1) throws StreamSegmentException;

    public void concat(SegmentHandle var1, long var2, String var4) throws StreamSegmentException;

    public void truncate(SegmentHandle var1, long var2) throws StreamSegmentException;

    public boolean supportsTruncation();

    @Override
    public void close();
}

