/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.CacheFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryCacheFactory
implements CacheFactory {
    @GuardedBy(value="caches")
    private final HashMap<String, InMemoryCache> caches = new HashMap();
    @GuardedBy(value="caches")
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String id) {
        HashMap<String, InMemoryCache> hashMap = this.caches;
        synchronized (hashMap) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            return this.caches.computeIfAbsent(id, key -> new InMemoryCache((String)key, this::cacheClosed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<InMemoryCache> toClose = null;
        HashMap<String, InMemoryCache> hashMap = this.caches;
        synchronized (hashMap) {
            if (!this.closed) {
                this.closed = true;
                toClose = new ArrayList<InMemoryCache>(this.caches.values());
            }
        }
        if (toClose != null) {
            toClose.forEach(InMemoryCache::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheClosed(String cacheId) {
        HashMap<String, InMemoryCache> hashMap = this.caches;
        synchronized (hashMap) {
            this.caches.remove(cacheId);
        }
    }
}

