/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.segmentstore.server.logs.operations.CompletableOperation;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class SegmentStoreMetrics {
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"segmentstore");
    private static final OpStatsLogger GLOBAL_OPERATION_LATENCY = STATS_LOGGER.createStats("pravega.segmentstore.container.operation.latency_ms", new String[0]);

    public static final class Container
    implements AutoCloseable {
        private final String[] containerTag;

        public Container(int containerId) {
            this.containerTag = MetricsTags.containerTag((int)containerId);
        }

        public void createSegment() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.create_segment_count", 1L, this.containerTag);
        }

        public void deleteSegment() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.delete_segment_count", 1L, this.containerTag);
        }

        public void append() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.append_count", 1L, this.containerTag);
        }

        public void appendWithOffset() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.append_offset_count", 1L, this.containerTag);
        }

        public void updateAttributes() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.update_attributes_count", 1L, this.containerTag);
        }

        public void getAttributes() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.get_attributes_count", 1L, this.containerTag);
        }

        public void read() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.read_count", 1L, this.containerTag);
        }

        public void getInfo() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.get_info_count", 1L, this.containerTag);
        }

        public void mergeSegment() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.merge_segment_count", 1L, this.containerTag);
        }

        public void seal() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.seal_count", 1L, this.containerTag);
        }

        public void truncate() {
            DYNAMIC_LOGGER.recordMeterEvents("pravega.segmentstore.container.truncate_count", 1L, this.containerTag);
        }

        @Override
        public void close() {
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.create_segment_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.delete_segment_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.merge_segment_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.append_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.append_offset_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.update_attributes_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.get_attributes_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.read_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.get_info_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.seal_count", this.containerTag);
            DYNAMIC_LOGGER.freezeMeter("pravega.segmentstore.container.truncate_count", this.containerTag);
        }
    }

    public static final class Metadata {
        private final String[] containerTag;

        public Metadata(int containerId) {
            this.containerTag = MetricsTags.containerTag((int)containerId);
        }

        public void segmentCount(int count) {
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.container.active_segments", (Number)count, this.containerTag);
        }
    }

    public static final class OperationProcessor
    implements AutoCloseable {
        private final OpStatsLogger operationQueueSize;
        private final OpStatsLogger operationsInFlight;
        private final OpStatsLogger operationQueueWaitTime;
        private final OpStatsLogger operationProcessorDelay;
        private final OpStatsLogger operationCommitLatency;
        private final OpStatsLogger operationLatency;
        private final OpStatsLogger memoryCommitCount;
        private final OpStatsLogger memoryCommitLatency;
        private final OpStatsLogger processOperationsLatency;
        private final OpStatsLogger processOperationsBatchSize;
        private final String[] containerTag;

        public OperationProcessor(int containerId) {
            this.containerTag = MetricsTags.containerTag((int)containerId);
            this.operationQueueSize = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_queue.size", this.containerTag);
            this.operationsInFlight = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_processor.in_flight", this.containerTag);
            this.operationQueueWaitTime = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_queue.wait_time", this.containerTag);
            this.operationProcessorDelay = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_processor.delay_ms", this.containerTag);
            this.operationCommitLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.latency_ms", this.containerTag);
            this.operationLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation.latency_ms", this.containerTag);
            this.memoryCommitLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.memory_latency_ms", this.containerTag);
            this.memoryCommitCount = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.memory_count", this.containerTag);
            this.processOperationsLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.process_operations.latency_ms", this.containerTag);
            this.processOperationsBatchSize = STATS_LOGGER.createStats("pravega.segmentstore.container.process_operations.batch_size", this.containerTag);
        }

        @Override
        public void close() {
            this.operationQueueSize.close();
            this.operationsInFlight.close();
            this.operationQueueWaitTime.close();
            this.operationProcessorDelay.close();
            this.operationCommitLatency.close();
            this.operationLatency.close();
            this.memoryCommitLatency.close();
            this.memoryCommitCount.close();
            this.processOperationsLatency.close();
            this.processOperationsBatchSize.close();
        }

        public void currentState(int queueSize, int inFlightCount) {
            this.operationQueueSize.reportSuccessValue((long)queueSize);
            this.operationsInFlight.reportSuccessValue((long)inFlightCount);
        }

        public void processingDelay(int millis) {
            this.operationProcessorDelay.reportSuccessValue((long)millis);
        }

        public void operationQueueWaitTime(long queueWaitTimeMillis) {
            this.operationQueueWaitTime.reportSuccessValue(queueWaitTimeMillis);
        }

        public void memoryCommit(int commitCount, Duration elapsed) {
            this.memoryCommitCount.reportSuccessValue((long)commitCount);
            this.memoryCommitLatency.reportSuccessEvent(elapsed);
        }

        public void operationLogTruncate(int count) {
            DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.container.operation.log_size", (long)(-count), this.containerTag);
        }

        public void operationLogInit() {
            DYNAMIC_LOGGER.updateCounterValue("pravega.segmentstore.container.operation.log_size", 0L, this.containerTag);
        }

        public void processOperations(int batchSize, long millis) {
            this.processOperationsBatchSize.reportSuccessValue((long)batchSize);
            this.processOperationsLatency.reportSuccessValue(millis);
        }

        public void operationsCompleted(int operationCount, Duration commitElapsed) {
            DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.container.operation.log_size", (long)operationCount, this.containerTag);
            this.operationCommitLatency.reportSuccessEvent(commitElapsed);
        }

        public void operationsCompleted(Collection<List<CompletableOperation>> operations, Duration commitElapsed) {
            this.operationsCompleted(operations.size(), commitElapsed);
            operations.stream().flatMap(Collection::stream).forEach(o -> {
                long millis = o.getTimer().getElapsedMillis();
                this.operationLatency.reportSuccessValue(millis);
                GLOBAL_OPERATION_LATENCY.reportSuccessValue(millis);
            });
        }

        public void operationsFailed(Collection<CompletableOperation> operations) {
            operations.forEach(o -> {
                long millis = o.getTimer().getElapsedMillis();
                this.operationLatency.reportFailValue(millis);
                GLOBAL_OPERATION_LATENCY.reportFailValue(millis);
            });
        }
    }

    public static final class ThreadPool
    implements AutoCloseable {
        private final OpStatsLogger queueSize;
        private final OpStatsLogger activeThreads;
        private final ScheduledExecutorService executor;
        private final ScheduledFuture<?> reporter;

        public ThreadPool(ScheduledExecutorService executor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.queueSize = STATS_LOGGER.createStats("pravega.segmentstore.thread_pool.queue_size", new String[0]);
            this.activeThreads = STATS_LOGGER.createStats("pravega.segmentstore.thread_pool.active_threads", new String[0]);
            this.reporter = executor.scheduleWithFixedDelay(this::report, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void close() {
            this.reporter.cancel(true);
            this.queueSize.close();
            this.activeThreads.close();
        }

        private void report() {
            ExecutorServiceHelpers.Snapshot s = ExecutorServiceHelpers.getSnapshot((ExecutorService)this.executor);
            if (s != null) {
                this.queueSize.reportSuccessValue((long)s.getQueueSize());
                this.activeThreads.reportSuccessValue((long)s.getActiveThreadCount());
            }
        }
    }

    public static final class CacheManager
    implements AutoCloseable {
        private final OpStatsLogger generationSpread = SegmentStoreMetrics.access$000().createStats("pravega.segmentstore.cache.gen", new String[0]);

        public void report(long totalBytes, int generationSpread) {
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.cache.size_bytes", (Number)totalBytes, new String[0]);
            this.generationSpread.reportSuccessValue((long)generationSpread);
        }

        @Override
        public void close() {
            this.generationSpread.close();
        }
    }
}

