/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;

public class ContainerConfig {
    public static final int MINIMUM_SEGMENT_METADATA_EXPIRATION_SECONDS = 60;
    public static final Property<Integer> SEGMENT_METADATA_EXPIRATION_SECONDS = Property.named((String)"segmentMetadataExpirationSeconds", (Object)60);
    public static final Property<Integer> METADATA_STORE_INIT_TIMEOUT_SECONDS = Property.named((String)"metadataStoreInitTimeoutSeconds", (Object)30);
    public static final Property<Integer> MAX_ACTIVE_SEGMENT_COUNT = Property.named((String)"maxActiveSegmentCount", (Object)25000);
    public static final Property<Integer> MAX_CONCURRENT_SEGMENT_EVICTION_COUNT = Property.named((String)"maxConcurrentSegmentEvictionCount", (Object)2500);
    public static final Property<Integer> MAX_CACHED_EXTENDED_ATTRIBUTE_COUNT = Property.named((String)"maxCachedExtendedAttributeCount", (Object)4096);
    private static final String COMPONENT_CODE = "containers";
    private final Duration segmentMetadataExpiration;
    private final Duration metadataStoreInitTimeout;
    private final int maxActiveSegmentCount;
    private final int maxConcurrentSegmentEvictionCount;
    private final int maxCachedExtendedAttributeCount;

    ContainerConfig(TypedProperties properties) {
        int segmentMetadataExpirationSeconds = properties.getInt(SEGMENT_METADATA_EXPIRATION_SECONDS);
        if (segmentMetadataExpirationSeconds < 60) {
            throw new ConfigurationException(String.format("Property '%s' must be at least %s.", SEGMENT_METADATA_EXPIRATION_SECONDS, 60));
        }
        this.segmentMetadataExpiration = Duration.ofSeconds(segmentMetadataExpirationSeconds);
        int metadataStoreInitSeconds = properties.getInt(METADATA_STORE_INIT_TIMEOUT_SECONDS);
        if (metadataStoreInitSeconds <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", METADATA_STORE_INIT_TIMEOUT_SECONDS));
        }
        this.metadataStoreInitTimeout = Duration.ofSeconds(metadataStoreInitSeconds);
        this.maxActiveSegmentCount = properties.getInt(MAX_ACTIVE_SEGMENT_COUNT);
        if (this.maxActiveSegmentCount <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MAX_ACTIVE_SEGMENT_COUNT));
        }
        this.maxConcurrentSegmentEvictionCount = properties.getInt(MAX_CONCURRENT_SEGMENT_EVICTION_COUNT);
        if (this.maxConcurrentSegmentEvictionCount <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MAX_CONCURRENT_SEGMENT_EVICTION_COUNT));
        }
        this.maxCachedExtendedAttributeCount = properties.getInt(MAX_CACHED_EXTENDED_ATTRIBUTE_COUNT);
        if (this.maxCachedExtendedAttributeCount <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MAX_CACHED_EXTENDED_ATTRIBUTE_COUNT));
        }
    }

    public static ConfigBuilder<ContainerConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ContainerConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getSegmentMetadataExpiration() {
        return this.segmentMetadataExpiration;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getMetadataStoreInitTimeout() {
        return this.metadataStoreInitTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxActiveSegmentCount() {
        return this.maxActiveSegmentCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxConcurrentSegmentEvictionCount() {
        return this.maxConcurrentSegmentEvictionCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxCachedExtendedAttributeCount() {
        return this.maxCachedExtendedAttributeCount;
    }
}

