/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.AbstractThreadPoolService;
import io.pravega.common.concurrent.CancellationToken;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.server.EvictableMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.MetadataStore;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class MetadataCleaner
extends AbstractThreadPoolService {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(MetadataCleaner.class);
    private final ContainerConfig config;
    private final EvictableMetadata metadata;
    private final MetadataStore metadataStore;
    private final Consumer<Collection<SegmentMetadata>> cleanupCallback;
    private final AtomicLong lastIterationSequenceNumber;
    private final CancellationToken stopToken;
    private final Object singleRunLock = new Object();
    @GuardedBy(value="singleRunLock")
    private CompletableFuture<Void> currentIteration = null;

    MetadataCleaner(@NonNull ContainerConfig config, @NonNull EvictableMetadata metadata, @NonNull MetadataStore metadataStore, @NonNull Consumer<Collection<SegmentMetadata>> cleanupCallback, @NonNull ScheduledExecutorService executor, String traceObjectId) {
        super(traceObjectId, executor);
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked @NonNull but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked @NonNull but is null");
        }
        if (cleanupCallback == null) {
            throw new NullPointerException("cleanupCallback is marked @NonNull but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.config = config;
        this.metadata = metadata;
        this.metadataStore = metadataStore;
        this.cleanupCallback = cleanupCallback;
        this.lastIterationSequenceNumber = new AtomicLong(metadata.getOperationSequenceNumber());
        this.stopToken = new CancellationToken();
    }

    protected Duration getShutdownTimeout() {
        return Duration.ofSeconds(30L);
    }

    protected CompletableFuture<Void> doRun() {
        return Futures.loop(() -> !this.stopToken.isCancellationRequested(), () -> this.delay().thenCompose(v -> this.runOnce()), (Executor)this.executor);
    }

    protected void doStop() {
        this.stopToken.requestCancellation();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> runOnce() {
        CompletableFuture<Void> result;
        Object object = this.singleRunLock;
        synchronized (object) {
            if (this.currentIteration != null) {
                return this.currentIteration;
            }
            this.currentIteration = new CompletableFuture();
            this.currentIteration.whenComplete((r, ex) -> {
                Object object = this.singleRunLock;
                synchronized (object) {
                    this.currentIteration = null;
                }
            });
            result = this.currentIteration;
        }
        Futures.completeAfter(this::runOnceInternal, result);
        return result;
    }

    private CompletableFuture<Void> runOnceInternal() {
        long lastSeqNo = this.lastIterationSequenceNumber.getAndSet(this.metadata.getOperationSequenceNumber());
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"metadataCleanup", (Object[])new Object[]{lastSeqNo});
        Collection<SegmentMetadata> cleanupCandidates = this.metadata.getEvictionCandidates(lastSeqNo, this.config.getMaxConcurrentSegmentEvictionCount());
        List cleanupTasks = cleanupCandidates.stream().filter(sm -> !sm.isDeleted() && !sm.isMerged()).map(sm -> this.metadataStore.updateSegmentInfo((SegmentMetadata)sm, this.config.getSegmentMetadataExpiration())).collect(Collectors.toList());
        return Futures.allOf(cleanupTasks).thenRunAsync(() -> {
            Collection<SegmentMetadata> evictedSegments = this.metadata.cleanup(cleanupCandidates, lastSeqNo);
            this.cleanupCallback.accept(evictedSegments);
            int evictedAttributes = this.metadata.cleanupExtendedAttributes(0, lastSeqNo);
            LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"metadataCleanup", (long)traceId, (Object[])new Object[]{evictedSegments.size(), evictedAttributes});
        }, this.executor);
    }

    private CompletableFuture<Void> delay() {
        CompletableFuture result = Futures.delayedFuture((Duration)this.config.getSegmentMetadataExpiration(), (ScheduledExecutorService)this.executor);
        this.stopToken.register(result);
        return result;
    }
}

