/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.AttributeIterator;
import io.pravega.segmentstore.server.SegmentMetadata;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
class SegmentAttributeIterator
implements AttributeIterator {
    private final AttributeIterator indexIterator;
    @GuardedBy(value="metadataAttributes")
    private final ArrayDeque<Map.Entry<UUID, Long>> metadataAttributes;
    private final UUID fromId;
    private final UUID toId;
    private final AtomicReference<UUID> lastIndexAttribute;

    SegmentAttributeIterator(@NonNull AttributeIterator indexIterator, @NonNull SegmentMetadata metadata, @NonNull UUID fromId, @NonNull UUID toId) {
        if (indexIterator == null) {
            throw new NullPointerException("indexIterator is marked @NonNull but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked @NonNull but is null");
        }
        if (fromId == null) {
            throw new NullPointerException("fromId is marked @NonNull but is null");
        }
        if (toId == null) {
            throw new NullPointerException("toId is marked @NonNull but is null");
        }
        this.indexIterator = indexIterator;
        this.metadataAttributes = metadata.getAttributes((key, value) -> fromId.compareTo((UUID)key) <= 0 && toId.compareTo((UUID)key) >= 0).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, UUID::compareTo)).collect(Collectors.toCollection(ArrayDeque::new));
        this.fromId = fromId;
        this.toId = toId;
        this.lastIndexAttribute = new AtomicReference();
    }

    public CompletableFuture<List<Map.Entry<UUID, Long>>> getNext() {
        return this.indexIterator.getNext().thenApply(this::mix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map.Entry<UUID, Long>> mix(List<Map.Entry<UUID, Long>> indexAttributes) {
        ArrayList<Map.Entry<UUID, Long>> result = new ArrayList<Map.Entry<UUID, Long>>();
        if (indexAttributes == null) {
            ArrayDeque<Map.Entry<UUID, Long>> arrayDeque = this.metadataAttributes;
            synchronized (arrayDeque) {
                while (!this.metadataAttributes.isEmpty()) {
                    this.include(this.metadataAttributes.removeFirst(), result);
                }
            }
            return result.isEmpty() ? null : result;
        }
        for (Map.Entry<UUID, Long> idxAttribute : indexAttributes) {
            this.checkIndexAttribute(idxAttribute.getKey());
            UUID lastMetadataAttribute = null;
            ArrayDeque<Map.Entry<UUID, Long>> arrayDeque = this.metadataAttributes;
            synchronized (arrayDeque) {
                while (!this.metadataAttributes.isEmpty() && this.metadataAttributes.peekFirst().getKey().compareTo(idxAttribute.getKey()) <= 0) {
                    lastMetadataAttribute = this.include(this.metadataAttributes.removeFirst(), result);
                }
            }
            if (lastMetadataAttribute != null && lastMetadataAttribute.equals(idxAttribute.getKey())) continue;
            this.include(idxAttribute, result);
        }
        return result;
    }

    private UUID include(Map.Entry<UUID, Long> e, List<Map.Entry<UUID, Long>> result) {
        if (e.getValue() != Long.MIN_VALUE) {
            result.add(e);
        }
        return e.getKey();
    }

    private void checkIndexAttribute(UUID attributeId) {
        UUID prevId = this.lastIndexAttribute.get();
        if (prevId != null) {
            Preconditions.checkArgument((prevId.compareTo(attributeId) < 0 ? 1 : 0) != 0, (String)"baseIterator did not return Attributes in order. Expected at greater than {%s}, found {%s}.", (Object)prevId, (Object)attributeId);
        }
        Preconditions.checkArgument((this.fromId.compareTo(attributeId) <= 0 && this.toId.compareTo(attributeId) >= 0 ? 1 : 0) != 0, (String)"baseIterator returned an Attribute Id that was out of range. Expected between {%s} and {%s}, found {%s}.", (Object)this.fromId, (Object)this.toId, (Object)attributeId);
        this.lastIndexAttribute.set(attributeId);
    }
}

