/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.CollectionHelpers;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamSegmentMetadata
implements UpdateableSegmentMetadata {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentMetadata.class);
    private final String traceObjectId;
    private final String name;
    private final long streamSegmentId;
    private final int containerId;
    @GuardedBy(value="this")
    private final Map<UUID, Long> coreAttributes;
    @GuardedBy(value="this")
    private final Map<UUID, ExtendedAttributeValue> extendedAttributes;
    @GuardedBy(value="this")
    private long storageLength;
    @GuardedBy(value="this")
    private long startOffset;
    @GuardedBy(value="this")
    private long length;
    @GuardedBy(value="this")
    private boolean sealed;
    @GuardedBy(value="this")
    private boolean sealedInStorage;
    @GuardedBy(value="this")
    private boolean deleted;
    @GuardedBy(value="this")
    private boolean deletedInStorage;
    @GuardedBy(value="this")
    private boolean merged;
    @GuardedBy(value="this")
    private ImmutableDate lastModified;
    @GuardedBy(value="this")
    private long lastUsed;
    @GuardedBy(value="this")
    private boolean active;
    @GuardedBy(value="this")
    private boolean pinned;

    public StreamSegmentMetadata(String streamSegmentName, long streamSegmentId, int containerId) {
        Exceptions.checkNotNullOrEmpty((String)streamSegmentName, (String)"streamSegmentName");
        Preconditions.checkArgument((streamSegmentId != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"streamSegmentId");
        Preconditions.checkArgument((containerId >= 0 ? 1 : 0) != 0, (Object)"containerId");
        this.traceObjectId = String.format("StreamSegment[%d-%d]", containerId, streamSegmentId);
        this.name = streamSegmentName;
        this.streamSegmentId = streamSegmentId;
        this.containerId = containerId;
        this.sealed = false;
        this.sealedInStorage = false;
        this.deleted = false;
        this.deletedInStorage = false;
        this.merged = false;
        this.startOffset = 0L;
        this.storageLength = -1L;
        this.length = -1L;
        this.coreAttributes = new HashMap<UUID, Long>();
        this.extendedAttributes = new HashMap<UUID, ExtendedAttributeValue>();
        this.lastModified = new ImmutableDate();
        this.lastUsed = 0L;
        this.active = true;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean isSealed() {
        return this.sealed;
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    public synchronized ImmutableDate getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getId() {
        return this.streamSegmentId;
    }

    @Override
    public int getContainerId() {
        return this.containerId;
    }

    @Override
    public synchronized boolean isMerged() {
        return this.merged;
    }

    @Override
    public synchronized boolean isDeletedInStorage() {
        return this.deletedInStorage;
    }

    @Override
    public synchronized boolean isSealedInStorage() {
        return this.sealedInStorage;
    }

    @Override
    public synchronized long getStorageLength() {
        return this.storageLength;
    }

    public synchronized long getStartOffset() {
        return this.startOffset;
    }

    public synchronized long getLength() {
        return this.length;
    }

    @Override
    public synchronized Map<UUID, Long> getAttributes() {
        return new AttributesView();
    }

    @Override
    public synchronized Map<UUID, Long> getAttributes(BiPredicate<UUID, Long> filter) {
        return this.getAttributes().entrySet().stream().filter(e -> filter.test((UUID)e.getKey(), (Long)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String toString() {
        return String.format("Id = %d, Start = %d, Length = %d, StorageLength = %d, Sealed(M/S) = %s/%s, Deleted = %s, Name = %s", this.getId(), this.getStartOffset(), this.getLength(), this.getStorageLength(), this.isSealed(), this.isSealedInStorage(), this.isDeleted(), this.getName());
    }

    @Override
    public synchronized void setStorageLength(long value) {
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"Storage Length must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((value >= this.storageLength ? 1 : 0) != 0, (String)"value", (String)"New Storage Length cannot be smaller than the previous one.", (Object[])new Object[0]);
        log.trace("{}: StorageLength changed from {} to {}.", new Object[]{this.traceObjectId, this.storageLength, value});
        this.storageLength = value;
    }

    @Override
    public synchronized void setStartOffset(long value) {
        if (this.startOffset == value) {
            return;
        }
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"StartOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((value >= this.startOffset ? 1 : 0) != 0, (String)"value", (String)"New StartOffset cannot be smaller than the previous one.", (Object[])new Object[0]);
        Exceptions.checkArgument((value <= this.length ? 1 : 0) != 0, (String)"value", (String)"New StartOffset cannot be larger than Length.", (Object[])new Object[0]);
        log.debug("{}: StartOffset changed from {} to {}.", new Object[]{this.traceObjectId, this.startOffset, value});
        this.startOffset = value;
    }

    @Override
    public synchronized void setLength(long value) {
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"Length must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((value >= this.length ? 1 : 0) != 0, (String)"value", (String)"New Length cannot be smaller than the previous one.", (Object[])new Object[0]);
        log.trace("{}: Length changed from {} to {}.", new Object[]{this.traceObjectId, this.length, value});
        this.length = value;
    }

    @Override
    public synchronized void markSealed() {
        log.debug("{}: Sealed = true.", (Object)this.traceObjectId);
        this.sealed = true;
    }

    @Override
    public synchronized void markSealedInStorage() {
        Preconditions.checkState((boolean)this.sealed, (Object)"Cannot mark SealedInStorage if not Sealed in Metadata.");
        log.debug("{}: SealedInStorage = true.", (Object)this.traceObjectId);
        this.sealedInStorage = true;
    }

    @Override
    public synchronized void markMerged() {
        log.debug("{}: Merged = true.", (Object)this.traceObjectId);
        this.merged = true;
    }

    @Override
    public synchronized void markDeleted() {
        log.debug("{}: Deleted = true.", (Object)this.traceObjectId);
        this.deleted = true;
    }

    @Override
    public synchronized void markDeletedInStorage() {
        Preconditions.checkState((boolean)this.deleted, (Object)"Cannot mark DeletedInStorage if not Deleted in Metadata.");
        log.debug("{}: DeletedInStorage = true.", (Object)this.traceObjectId);
        this.deletedInStorage = true;
    }

    @Override
    public synchronized void markPinned() {
        log.debug("{}: Pinned = true.", (Object)this.traceObjectId);
        this.pinned = true;
    }

    @Override
    public synchronized void setLastModified(ImmutableDate date) {
        this.lastModified = date;
        log.trace("{}: LastModified = {}.", (Object)this.traceObjectId, (Object)this.lastModified);
    }

    @Override
    public synchronized void updateAttributes(Map<UUID, Long> attributes) {
        attributes.forEach((id, value) -> {
            if (Attributes.isCoreAttribute((UUID)id)) {
                this.coreAttributes.put((UUID)id, (Long)value);
            } else {
                this.extendedAttributes.put((UUID)id, new ExtendedAttributeValue((long)value));
            }
        });
    }

    @Override
    public synchronized void copyFrom(SegmentMetadata base) {
        Exceptions.checkArgument((this.getId() == base.getId() ? 1 : 0) != 0, (String)"base", (String)"Given SegmentMetadata refers to a different StreamSegment than this one (SegmentId).", (Object[])new Object[0]);
        Exceptions.checkArgument((boolean)this.getName().equals(base.getName()), (String)"base", (String)"Given SegmentMetadata refers to a different StreamSegment than this one (SegmentName).", (Object[])new Object[0]);
        log.debug("{}: copyFrom {}.", (Object)this.traceObjectId, (Object)base.getClass().getSimpleName());
        this.setStorageLength(base.getStorageLength());
        this.setLength(base.getLength());
        this.setStartOffset(base.getStartOffset());
        this.setLastModified(base.getLastModified());
        this.updateAttributes(base.getAttributes());
        if (base.isSealed()) {
            this.markSealed();
            if (base.isSealedInStorage()) {
                this.markSealedInStorage();
            }
        }
        if (base.isMerged()) {
            this.markMerged();
        }
        if (base.isDeleted()) {
            this.markDeleted();
            if (base.isDeletedInStorage()) {
                this.markDeletedInStorage();
            }
        }
        if (base.isPinned()) {
            this.markPinned();
        }
        this.setLastUsed(base.getLastUsed());
    }

    @Override
    public synchronized void setLastUsed(long value) {
        this.lastUsed = Math.max(value, this.lastUsed);
    }

    @Override
    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized SegmentProperties getSnapshot() {
        return StreamSegmentInformation.from((SegmentProperties)this).attributes(new HashMap<UUID, Long>(this.getAttributes())).build();
    }

    @Override
    public synchronized boolean isPinned() {
        return this.pinned;
    }

    @VisibleForTesting
    public synchronized void markInactive() {
        this.active = false;
    }

    synchronized int cleanupAttributes(int maximumAttributeCount, long lastUsedCutoff) {
        if (this.extendedAttributes.size() <= maximumAttributeCount) {
            return 0;
        }
        List candidates = this.extendedAttributes.entrySet().stream().filter(e -> ((ExtendedAttributeValue)e.getValue()).lastUsed < lastUsedCutoff).sorted(Comparator.comparingLong(e -> ((ExtendedAttributeValue)e.getValue()).lastUsed)).collect(Collectors.toList());
        int count = 0;
        for (Map.Entry e2 : candidates) {
            if (this.extendedAttributes.size() <= maximumAttributeCount) break;
            this.extendedAttributes.remove(e2.getKey());
            ++count;
        }
        log.debug("{}: Evicted {} attribute(s).", (Object)this.traceObjectId, (Object)count);
        return count;
    }

    private class AttributesView
    implements Map<UUID, Long> {
        private AttributesView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return StreamSegmentMetadata.this.coreAttributes.size() + StreamSegmentMetadata.this.extendedAttributes.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return StreamSegmentMetadata.this.coreAttributes.isEmpty() && StreamSegmentMetadata.this.extendedAttributes.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object o) {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return StreamSegmentMetadata.this.coreAttributes.containsKey(o) || StreamSegmentMetadata.this.extendedAttributes.containsKey(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long get(Object o) {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                ExtendedAttributeValue r;
                Long result = (Long)StreamSegmentMetadata.this.coreAttributes.get(o);
                if (result == null && (r = (ExtendedAttributeValue)StreamSegmentMetadata.this.extendedAttributes.get(o)) != null) {
                    result = r.getValueAndTouch();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<UUID> keySet() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return CollectionHelpers.joinSets(StreamSegmentMetadata.this.coreAttributes.keySet(), StreamSegmentMetadata.this.extendedAttributes.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Long> values() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return CollectionHelpers.joinCollections(StreamSegmentMetadata.this.coreAttributes.values(), Callbacks::identity, StreamSegmentMetadata.this.extendedAttributes.values(), e -> ((ExtendedAttributeValue)e).value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<UUID, Long>> entrySet() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return CollectionHelpers.joinSets(StreamSegmentMetadata.this.coreAttributes.entrySet(), Callbacks::identity, StreamSegmentMetadata.this.extendedAttributes.entrySet(), e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), ((ExtendedAttributeValue)e.getValue()).value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return String.format("Core: %s, Extended: %s", StreamSegmentMetadata.this.coreAttributes, StreamSegmentMetadata.this.extendedAttributes);
            }
        }

        @Override
        public boolean containsValue(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long put(UUID uuid, Long aLong) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends UUID, ? extends Long> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class ExtendedAttributeValue {
        private final long value;
        @GuardedBy(value="StreamSegmentMetadata.this")
        private long lastUsed;

        ExtendedAttributeValue(long value) {
            this.value = value;
            this.lastUsed = StreamSegmentMetadata.this.getLastUsed();
        }

        @GuardedBy(value="StreamSegmentMetadata.this")
        long getValueAndTouch() {
            this.lastUsed = StreamSegmentMetadata.this.getLastUsed();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StreamSegmentMetadata streamSegmentMetadata = StreamSegmentMetadata.this;
            synchronized (streamSegmentMetadata) {
                return String.format("%d (LastUsed=%d)", this.value, this.lastUsed);
            }
        }
    }
}

