/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.ContainerException;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.TooManyActiveSegmentsException;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.containers.StreamSegmentMetadata;
import io.pravega.segmentstore.server.logs.MetadataUpdateException;
import io.pravega.segmentstore.server.logs.SegmentMetadataUpdateTransaction;
import io.pravega.segmentstore.server.logs.operations.CheckpointOperationBase;
import io.pravega.segmentstore.server.logs.operations.DeleteSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageMetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentMapOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentSealOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentTruncateOperation;
import io.pravega.segmentstore.server.logs.operations.UpdateAttributesOperation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ContainerMetadataUpdateTransaction
implements ContainerMetadata {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ContainerMetadataUpdateTransaction.class);
    private static final MetadataCheckpointSerializer METADATA_CHECKPOINT_SERIALIZER = new MetadataCheckpointSerializer();
    private static final StorageCheckpointSerializer STORAGE_CHECKPOINT_SERIALIZER = new StorageCheckpointSerializer();
    private final ContainerMetadata realMetadata;
    private final HashMap<Long, SegmentMetadataUpdateTransaction> segmentUpdates;
    private final HashMap<Long, UpdateableSegmentMetadata> newSegments;
    private final HashMap<String, Long> newSegmentNames;
    private final List<Long> newTruncationPoints;
    private final int containerId;
    private final boolean recoveryMode;
    private int maximumActiveSegmentCount;
    private int baseNewSegmentCount;
    private ContainerMetadata baseMetadata;
    private long newSequenceNumber;
    private final long transactionId;
    private final String traceObjectId;
    private boolean processedCheckpoint;
    private boolean sealed;

    ContainerMetadataUpdateTransaction(ContainerMetadata baseMetadata, ContainerMetadata realMetadata, long transactionId) {
        this.baseMetadata = (ContainerMetadata)Preconditions.checkNotNull((Object)baseMetadata, (Object)"baseMetadata");
        this.realMetadata = (ContainerMetadata)Preconditions.checkNotNull((Object)realMetadata, (Object)"realMetadata");
        this.transactionId = transactionId;
        this.containerId = this.baseMetadata.getContainerId();
        this.recoveryMode = this.baseMetadata.isRecoveryMode();
        this.maximumActiveSegmentCount = this.baseMetadata.getMaximumActiveSegmentCount();
        this.baseNewSegmentCount = this.getNewSegmentCount(baseMetadata);
        this.traceObjectId = String.format("MetadataUpdate[%d-%d]", this.containerId, transactionId);
        this.segmentUpdates = new HashMap();
        this.newTruncationPoints = new ArrayList<Long>();
        this.newSegments = new HashMap();
        this.newSegmentNames = new HashMap();
        this.sealed = false;
        this.resetNewSequenceNumber();
    }

    @Override
    public long getContainerEpoch() {
        throw new UnsupportedOperationException("getContainerEpoch() is not supported in " + this.getClass().getName());
    }

    @Override
    public long getOperationSequenceNumber() {
        Preconditions.checkState((!this.isRecoveryMode() ? 1 : 0) != 0, (Object)"GetOperationSequenceNumber cannot be invoked in recovery mode.");
        return this.realMetadata.getOperationSequenceNumber();
    }

    @Override
    public long getStreamSegmentId(String segmentName, boolean updateLastUsed) {
        long existingSegmentId = this.newSegmentNames.getOrDefault(segmentName, Long.MIN_VALUE);
        if (existingSegmentId == Long.MIN_VALUE) {
            existingSegmentId = this.baseMetadata.getStreamSegmentId(segmentName, false);
        }
        return existingSegmentId;
    }

    @Override
    public SegmentMetadata getStreamSegmentMetadata(long segmentId) {
        SegmentMetadata sm = this.segmentUpdates.getOrDefault(segmentId, null);
        if (sm == null && (sm = (SegmentMetadata)this.newSegments.getOrDefault(segmentId, null)) == null) {
            sm = this.baseMetadata.getStreamSegmentMetadata(segmentId);
        }
        return sm;
    }

    @Override
    public Collection<Long> getAllStreamSegmentIds() {
        Collection<Long> baseSegmentIds = this.baseMetadata.getAllStreamSegmentIds();
        ArrayList<Long> result = new ArrayList<Long>(baseSegmentIds.size() + this.newSegments.size());
        result.addAll(baseSegmentIds);
        result.addAll(this.newSegments.keySet());
        return result;
    }

    @Override
    public int getActiveSegmentCount() {
        return this.realMetadata.getActiveSegmentCount() + this.getNewSegmentCount();
    }

    private int getNewSegmentCount() {
        return this.baseNewSegmentCount + this.newSegments.size();
    }

    private int getNewSegmentCount(ContainerMetadata baseMetadata) {
        if (baseMetadata instanceof ContainerMetadataUpdateTransaction) {
            return ((ContainerMetadataUpdateTransaction)baseMetadata).getNewSegmentCount();
        }
        return 0;
    }

    void seal() {
        this.sealed = true;
    }

    void rebase(ContainerMetadata baseMetadata) {
        Preconditions.checkArgument((baseMetadata.getContainerId() == this.containerId ? 1 : 0) != 0, (Object)"ContainerId mismatch");
        Preconditions.checkArgument((baseMetadata.isRecoveryMode() == this.isRecoveryMode() ? 1 : 0) != 0, (Object)"isRecoveryMode mismatch");
        this.baseMetadata = baseMetadata;
        this.maximumActiveSegmentCount = baseMetadata.getMaximumActiveSegmentCount();
        this.baseNewSegmentCount = this.getNewSegmentCount(baseMetadata);
        this.resetNewSequenceNumber();
    }

    void commit(UpdateableContainerMetadata target) {
        Preconditions.checkArgument((target.getContainerId() == this.containerId ? 1 : 0) != 0, (Object)"ContainerId mismatch");
        Preconditions.checkArgument((target.isRecoveryMode() == this.isRecoveryMode() ? 1 : 0) != 0, (Object)"isRecoveryMode mismatch");
        if (target.isRecoveryMode()) {
            if (this.processedCheckpoint) {
                target.reset();
            }
            assert (this.newSequenceNumber >= 0L) : "Invalid Sequence Number " + this.newSequenceNumber;
            target.setOperationSequenceNumber(this.newSequenceNumber);
        }
        this.segmentUpdates.values().forEach(txn -> {
            UpdateableSegmentMetadata targetSegmentMetadata = target.getStreamSegmentMetadata(txn.getId());
            if (targetSegmentMetadata == null) {
                targetSegmentMetadata = this.newSegments.get(txn.getId());
            }
            txn.apply(targetSegmentMetadata);
        });
        this.copySegmentMetadata(this.newSegments.values(), target);
        this.newTruncationPoints.forEach(target::setValidTruncationPoint);
        this.clear();
    }

    @VisibleForTesting
    void clear() {
        this.segmentUpdates.clear();
        this.newSegments.clear();
        this.newSegmentNames.clear();
        this.newTruncationPoints.clear();
        this.processedCheckpoint = false;
        this.resetNewSequenceNumber();
    }

    private void resetNewSequenceNumber() {
        this.newSequenceNumber = this.baseMetadata.isRecoveryMode() ? 0L : Long.MIN_VALUE;
    }

    void setOperationSequenceNumber(long value) {
        this.checkNotSealed();
        Preconditions.checkState((boolean)this.recoveryMode, (Object)"Cannot set Sequence Number because ContainerMetadata is not in recovery mode.");
        this.newSequenceNumber = value;
    }

    void preProcessOperation(Operation operation) throws ContainerException, StreamSegmentException {
        this.checkNotSealed();
        if (operation instanceof SegmentOperation) {
            SegmentMetadataUpdateTransaction segmentMetadata = this.getSegmentUpdateTransaction(((SegmentOperation)((Object)operation)).getStreamSegmentId());
            if (segmentMetadata.isDeleted()) {
                throw new StreamSegmentNotExistsException(segmentMetadata.getName());
            }
            if (operation instanceof StreamSegmentAppendOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentAppendOperation)operation);
            } else if (operation instanceof StreamSegmentSealOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentSealOperation)operation);
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mbe = (MergeSegmentOperation)operation;
                SegmentMetadataUpdateTransaction sourceMetadata = this.getSegmentUpdateTransaction(mbe.getSourceSegmentId());
                sourceMetadata.preProcessAsSourceSegment(mbe);
                segmentMetadata.preProcessAsTargetSegment(mbe, sourceMetadata);
            } else if (operation instanceof UpdateAttributesOperation) {
                segmentMetadata.preProcessOperation((UpdateAttributesOperation)operation);
            } else if (operation instanceof StreamSegmentTruncateOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentTruncateOperation)operation);
            } else if (operation instanceof DeleteSegmentOperation) {
                segmentMetadata.preProcessOperation((DeleteSegmentOperation)operation);
            }
        }
        if (operation instanceof MetadataCheckpointOperation) {
            this.processMetadataOperation((MetadataCheckpointOperation)operation);
        } else if (operation instanceof StorageMetadataCheckpointOperation) {
            this.processMetadataOperation((StorageMetadataCheckpointOperation)operation);
        } else if (operation instanceof StreamSegmentMapOperation) {
            this.preProcessMetadataOperation((StreamSegmentMapOperation)operation);
        }
    }

    void acceptOperation(Operation operation) throws MetadataUpdateException {
        this.checkNotSealed();
        if (operation instanceof SegmentOperation) {
            SegmentMetadataUpdateTransaction segmentMetadata = this.getSegmentUpdateTransaction(((SegmentOperation)((Object)operation)).getStreamSegmentId());
            segmentMetadata.setLastUsed(operation.getSequenceNumber());
            if (operation instanceof StreamSegmentAppendOperation) {
                segmentMetadata.acceptOperation((StreamSegmentAppendOperation)operation);
            } else if (operation instanceof StreamSegmentSealOperation) {
                segmentMetadata.acceptOperation((StreamSegmentSealOperation)operation);
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mto = (MergeSegmentOperation)operation;
                SegmentMetadataUpdateTransaction sourceMetadata = this.getSegmentUpdateTransaction(mto.getSourceSegmentId());
                sourceMetadata.acceptAsSourceSegment(mto);
                sourceMetadata.setLastUsed(operation.getSequenceNumber());
                segmentMetadata.acceptAsTargetSegment(mto, sourceMetadata);
            } else if (operation instanceof UpdateAttributesOperation) {
                segmentMetadata.acceptOperation((UpdateAttributesOperation)operation);
            } else if (operation instanceof StreamSegmentTruncateOperation) {
                segmentMetadata.acceptOperation((StreamSegmentTruncateOperation)operation);
            } else if (operation instanceof DeleteSegmentOperation) {
                segmentMetadata.acceptOperation((DeleteSegmentOperation)operation);
            }
        }
        if (operation instanceof CheckpointOperationBase) {
            if (operation instanceof MetadataCheckpointOperation) {
                this.newTruncationPoints.add(operation.getSequenceNumber());
            }
            ((CheckpointOperationBase)operation).clearContents();
        } else if (operation instanceof StreamSegmentMapOperation) {
            this.acceptMetadataOperation((StreamSegmentMapOperation)operation);
        }
    }

    private void preProcessMetadataOperation(StreamSegmentMapOperation operation) throws ContainerException {
        this.checkExistingMapping(operation);
        this.assignUniqueSegmentId(operation);
    }

    private void processMetadataOperation(MetadataCheckpointOperation operation) throws MetadataUpdateException {
        try {
            if (this.recoveryMode) {
                if (this.processedCheckpoint) {
                    log.debug("{}: Skipping MetadataCheckpointOperation with SequenceNumber {} because we already have metadata changes.", (Object)this.traceObjectId, (Object)operation.getSequenceNumber());
                    return;
                }
                log.info("{}: Recovering MetadataCheckpointOperation with SequenceNumber {}.", (Object)this.traceObjectId, (Object)operation.getSequenceNumber());
                this.clear();
                this.setOperationSequenceNumber(operation.getSequenceNumber());
                METADATA_CHECKPOINT_SERIALIZER.deserialize((ArrayView)operation.getContents(), this);
                this.processedCheckpoint = true;
            } else {
                operation.setContents(METADATA_CHECKPOINT_SERIALIZER.serialize(this));
            }
        }
        catch (IOException ex) {
            throw new MetadataUpdateException(this.containerId, "Unable to process MetadataCheckpointOperation " + operation, ex);
        }
    }

    private void processMetadataOperation(StorageMetadataCheckpointOperation operation) throws MetadataUpdateException {
        try {
            if (this.recoveryMode) {
                STORAGE_CHECKPOINT_SERIALIZER.deserialize((ArrayView)operation.getContents(), this);
            } else {
                operation.setContents(STORAGE_CHECKPOINT_SERIALIZER.serialize(this));
            }
        }
        catch (IOException ex) {
            throw new MetadataUpdateException(this.containerId, "Unable to process StorageMetadataCheckpointOperation " + operation, ex);
        }
    }

    private void acceptMetadataOperation(StreamSegmentMapOperation operation) throws MetadataUpdateException {
        if (operation.getStreamSegmentId() == Long.MIN_VALUE) {
            throw new MetadataUpdateException(this.containerId, "StreamSegmentMapOperation does not have a SegmentId assigned: " + operation);
        }
        SegmentMetadataUpdateTransaction segmentMetadata = this.getOrCreateSegmentUpdateTransaction(operation.getStreamSegmentName(), operation.getStreamSegmentId());
        this.updateMetadata(operation, segmentMetadata);
    }

    private void updateMetadata(StreamSegmentMapOperation mapping, UpdateableSegmentMetadata metadata) {
        metadata.setStorageLength(mapping.getLength());
        metadata.setLength(Math.max(mapping.getLength(), metadata.getLength()));
        if (metadata.getLength() > 0L) {
            metadata.setStartOffset(Math.min(mapping.getStartOffset(), metadata.getLength() - 1L));
        }
        if (mapping.isSealed()) {
            metadata.markSealed();
        }
        if (mapping.isPinned()) {
            metadata.markPinned();
        }
        metadata.updateAttributes(mapping.getAttributes());
    }

    private void checkExistingMapping(StreamSegmentMapOperation operation) throws MetadataUpdateException {
        long existingSegmentId = this.getStreamSegmentId(operation.getStreamSegmentName(), false);
        if (existingSegmentId != Long.MIN_VALUE && existingSegmentId != operation.getStreamSegmentId()) {
            throw new MetadataUpdateException(this.containerId, String.format("Operation '%s' wants to map a Segment that is already mapped in the metadata. Existing Id = %d.", operation, existingSegmentId));
        }
    }

    private void assignUniqueSegmentId(StreamSegmentMapOperation mapping) throws TooManyActiveSegmentsException {
        if (!this.recoveryMode) {
            if (this.getActiveSegmentCount() >= this.maximumActiveSegmentCount && !mapping.isPinned()) {
                throw new TooManyActiveSegmentsException(this.containerId, this.maximumActiveSegmentCount);
            }
            if (mapping.getStreamSegmentId() == Long.MIN_VALUE) {
                mapping.setStreamSegmentId(this.generateUniqueSegmentId());
            }
        }
    }

    private long generateUniqueSegmentId() {
        long segmentId = this.realMetadata.getOperationSequenceNumber();
        while (this.newSegments.containsKey(segmentId) || this.baseMetadata.getStreamSegmentMetadata(segmentId) != null) {
            ++segmentId;
        }
        assert (segmentId >= 0L) : "Invalid generated SegmentId";
        return segmentId;
    }

    private SegmentMetadataUpdateTransaction getSegmentUpdateTransaction(long segmentId) throws MetadataUpdateException {
        SegmentMetadataUpdateTransaction tsm = this.tryGetSegmentUpdateTransaction(segmentId);
        if (tsm == null) {
            throw new MetadataUpdateException(this.containerId, String.format("No metadata entry exists for Segment Id %d.", segmentId));
        }
        return tsm;
    }

    private SegmentMetadataUpdateTransaction getOrCreateSegmentUpdateTransaction(String segmentName, long segmentId) {
        SegmentMetadataUpdateTransaction sm = this.tryGetSegmentUpdateTransaction(segmentId);
        if (sm == null) {
            UpdateableSegmentMetadata baseSegmentMetadata = this.createSegmentMetadata(segmentName, segmentId);
            sm = new SegmentMetadataUpdateTransaction(baseSegmentMetadata, this.recoveryMode);
            this.segmentUpdates.put(segmentId, sm);
        }
        return sm;
    }

    private SegmentMetadataUpdateTransaction tryGetSegmentUpdateTransaction(long segmentId) {
        SegmentMetadataUpdateTransaction sm = this.segmentUpdates.getOrDefault(segmentId, null);
        if (sm == null) {
            SegmentMetadata baseSegmentMetadata = this.baseMetadata.getStreamSegmentMetadata(segmentId);
            if (baseSegmentMetadata == null) {
                baseSegmentMetadata = this.newSegments.getOrDefault(segmentId, null);
            }
            if (baseSegmentMetadata != null) {
                sm = new SegmentMetadataUpdateTransaction(baseSegmentMetadata, this.recoveryMode);
                this.segmentUpdates.put(segmentId, sm);
            }
        }
        return sm;
    }

    private UpdateableSegmentMetadata createSegmentMetadata(String segmentName, long segmentId) {
        StreamSegmentMetadata metadata = new StreamSegmentMetadata(segmentName, segmentId, this.containerId);
        this.newSegments.put(metadata.getId(), metadata);
        this.newSegmentNames.put(metadata.getName(), metadata.getId());
        return metadata;
    }

    private void copySegmentMetadata(Collection<UpdateableSegmentMetadata> newSegments, UpdateableContainerMetadata target) {
        for (SegmentMetadata segmentMetadata : newSegments) {
            UpdateableSegmentMetadata existingMetadata = target.mapStreamSegmentId(segmentMetadata.getName(), segmentMetadata.getId());
            existingMetadata.copyFrom(segmentMetadata);
        }
    }

    private void checkNotSealed() {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (String)"%s has been sealed and can no longer accept changes.", (Object)this.traceObjectId);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getContainerId() {
        return this.containerId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getMaximumActiveSegmentCount() {
        return this.maximumActiveSegmentCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTransactionId() {
        return this.transactionId;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSealed() {
        return this.sealed;
    }

    private static class MetadataCheckpointSerializer
    extends VersionedSerializer.Direct<ContainerMetadataUpdateTransaction> {
        private MetadataCheckpointSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ContainerMetadataUpdateTransaction t, RevisionDataOutput output) throws IOException {
            output.writeCompactInt(t.containerId);
            ArrayList toSerialize = new ArrayList();
            t.baseMetadata.getAllStreamSegmentIds().stream().filter(segmentId -> !t.segmentUpdates.containsKey(segmentId)).forEach(segmentId -> toSerialize.add(t.baseMetadata.getStreamSegmentMetadata((long)segmentId)));
            t.newSegments.values().stream().filter(sm -> !t.segmentUpdates.containsKey(sm.getId())).forEach(toSerialize::add);
            toSerialize.addAll(t.segmentUpdates.values());
            output.writeCollection(toSerialize, this::writeSegmentMetadata00);
        }

        private void read00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            int containerId = input.readCompactInt();
            if (t.containerId != containerId) {
                throw new SerializationException(String.format("Invalid ContainerId. Expected '%d', actual '%d'.", t.containerId, containerId));
            }
            input.readCollection(s -> this.readSegmentMetadata00(s, t));
        }

        private void writeSegmentMetadata00(RevisionDataOutput output, SegmentMetadata sm) throws IOException {
            output.writeLong(sm.getId());
            output.writeUTF(sm.getName());
            output.writeLong(sm.getLength());
            output.writeLong(sm.getStorageLength());
            output.writeBoolean(sm.isMerged());
            output.writeBoolean(sm.isSealed());
            output.writeBoolean(sm.isSealedInStorage());
            output.writeBoolean(sm.isDeleted());
            output.writeBoolean(sm.isDeletedInStorage());
            output.writeLong(sm.getLastModified().getTime());
            output.writeLong(sm.getStartOffset());
            output.writeMap(Attributes.getCoreNonNullAttributes(sm.getAttributes()), RevisionDataOutput::writeUUID, DataOutput::writeLong);
        }

        private UpdateableSegmentMetadata readSegmentMetadata00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            boolean isDeletedInStorage;
            boolean isDeleted;
            boolean isSealedInStorage;
            boolean isSealed;
            long segmentId = input.readLong();
            String name = input.readUTF();
            SegmentMetadataUpdateTransaction metadata = t.getOrCreateSegmentUpdateTransaction(name, segmentId);
            metadata.setLength(input.readLong());
            metadata.setStorageLength(input.readLong());
            boolean isMerged = input.readBoolean();
            if (isMerged) {
                metadata.markMerged();
            }
            if (isSealed = input.readBoolean()) {
                metadata.markSealed();
            }
            if (isSealedInStorage = input.readBoolean()) {
                metadata.markSealedInStorage();
            }
            if (isDeleted = input.readBoolean()) {
                metadata.markDeleted();
            }
            if (isDeletedInStorage = input.readBoolean()) {
                metadata.markDeletedInStorage();
            }
            ImmutableDate lastModified = new ImmutableDate(input.readLong());
            metadata.setLastModified(lastModified);
            metadata.setStartOffset(input.readLong());
            Map attributes = input.readMap(RevisionDataInput::readUUID, DataInput::readLong);
            metadata.updateAttributes(attributes);
            return metadata;
        }
    }

    private static class StorageCheckpointSerializer
    extends VersionedSerializer.Direct<ContainerMetadataUpdateTransaction> {
        private StorageCheckpointSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ContainerMetadataUpdateTransaction t, RevisionDataOutput output) throws IOException {
            List toSerialize = t.realMetadata.getAllStreamSegmentIds().stream().map(t.realMetadata::getStreamSegmentMetadata).collect(Collectors.toList());
            output.writeCollection(toSerialize, this::writeSegmentMetadata00);
        }

        private void read00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            input.readCollection(s -> this.readSegmentMetadata00(s, t));
        }

        private void writeSegmentMetadata00(RevisionDataOutput output, SegmentMetadata sm) throws IOException {
            output.writeLong(sm.getId());
            output.writeLong(sm.getStorageLength());
            output.writeBoolean(sm.isSealedInStorage());
            output.writeBoolean(sm.isDeleted());
            output.writeBoolean(sm.isDeletedInStorage());
        }

        private SegmentMetadata readSegmentMetadata00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            long segmentId = input.readLong();
            SegmentMetadataUpdateTransaction metadata = t.getSegmentUpdateTransaction(segmentId);
            long storageLength = input.readLong();
            boolean sealedInStorage = input.readBoolean();
            boolean deleted = input.readBoolean();
            boolean deletedInStorage = input.readBoolean();
            metadata.updateStorageState(storageLength, sealedInStorage, deleted, deletedInStorage);
            return metadata;
        }
    }
}

