/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.util.SequencedItemList;
import io.pravega.segmentstore.server.logs.DataFrame;
import io.pravega.segmentstore.server.logs.DataFrameOutputStream;
import io.pravega.segmentstore.server.logs.Serializer;
import io.pravega.segmentstore.server.logs.operations.CompletableOperation;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.LogAddress;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class DataFrameBuilder<T extends SequencedItemList.Element>
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(DataFrameBuilder.class);
    private final DataFrameOutputStream outputStream;
    private final DurableDataLog targetLog;
    private final Serializer<T> serializer;
    private final Args args;
    private final AtomicBoolean closed;
    private long lastSerializedSequenceNumber;
    private long lastStartedSequenceNumber;
    private final AtomicReference<Throwable> failureCause;

    DataFrameBuilder(DurableDataLog targetLog, Serializer<T> serializer, Args args) {
        this.targetLog = (DurableDataLog)Preconditions.checkNotNull((Object)targetLog, (Object)"targetLog");
        this.serializer = (Serializer)Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.args = (Args)Preconditions.checkNotNull((Object)args, (Object)"args");
        Preconditions.checkNotNull(args.commitSuccess, (Object)"args.commitSuccess");
        Preconditions.checkNotNull(args.commitFailure, (Object)"args.commitFailure");
        this.outputStream = new DataFrameOutputStream(targetLog.getWriteSettings().getMaxWriteLength(), this::handleDataFrameComplete);
        this.lastSerializedSequenceNumber = -1L;
        this.lastStartedSequenceNumber = -1L;
        this.failureCause = new AtomicReference();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            this.outputStream.close();
        }
    }

    void flush() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.outputStream.flush();
        this.outputStream.releaseBuffer();
    }

    Throwable failureCause() {
        return this.failureCause.get();
    }

    void append(T logItem) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        long seqNo = logItem.getSequenceNumber();
        Exceptions.checkArgument((this.lastSerializedSequenceNumber < seqNo ? 1 : 0) != 0, (String)"logItem", (String)"Invalid sequence number. Expected: greater than %d, given: %d.", (Object[])new Object[]{this.lastSerializedSequenceNumber, seqNo});
        long previousLastStartedSequenceNumber = this.lastStartedSequenceNumber;
        try {
            this.outputStream.startNewRecord();
            this.lastStartedSequenceNumber = seqNo;
            this.serializer.serialize(this.outputStream, logItem);
            this.outputStream.endRecord();
            this.lastSerializedSequenceNumber = seqNo;
        }
        catch (Exception ex) {
            if (this.closed.get()) {
                throw new ObjectClosedException((Object)this, (Throwable)ex);
            }
            if (ex instanceof ObjectClosedException) {
                this.close();
            } else {
                this.outputStream.discardRecord();
                this.lastStartedSequenceNumber = previousLastStartedSequenceNumber;
            }
            throw ex;
        }
    }

    private void handleDataFrameComplete(DataFrame dataFrame) {
        Exceptions.checkArgument((boolean)dataFrame.isSealed(), (String)"dataFrame", (String)"Cannot publish a non-sealed DataFrame.", (Object[])new Object[0]);
        CommitArgs commitArgs = new CommitArgs(this.lastSerializedSequenceNumber, this.lastStartedSequenceNumber, dataFrame.getLength());
        try {
            this.args.beforeCommit.accept(commitArgs);
            ((CompletableFuture)this.targetLog.append(dataFrame.getData(), this.args.writeTimeout).thenAcceptAsync(logAddress -> {
                commitArgs.setLogAddress(logAddress);
                this.args.commitSuccess.accept(commitArgs);
            }, this.args.executor)).exceptionally(ex -> this.handleProcessingException((Throwable)ex, commitArgs));
        }
        catch (Throwable ex2) {
            this.handleProcessingException(ex2, commitArgs);
            throw ex2;
        }
    }

    private Void handleProcessingException(Throwable ex, CommitArgs commitArgs) {
        if (!this.isShutdownException(ex = Exceptions.unwrap((Throwable)ex))) {
            this.failureCause.compareAndSet(null, ex);
        }
        this.args.commitFailure.accept(ex, commitArgs);
        this.close();
        return null;
    }

    private boolean isShutdownException(Throwable ex) {
        return ex instanceof ObjectClosedException || ex instanceof CancellationException;
    }

    static class Args {
        final Consumer<CommitArgs> beforeCommit;
        final Consumer<CommitArgs> commitSuccess;
        final BiConsumer<Throwable, CommitArgs> commitFailure;
        final Executor executor;
        final Duration writeTimeout = Duration.ofSeconds(30L);

        @ConstructorProperties(value={"beforeCommit", "commitSuccess", "commitFailure", "executor"})
        @SuppressFBWarnings(justification="generated code")
        public Args(Consumer<CommitArgs> beforeCommit, Consumer<CommitArgs> commitSuccess, BiConsumer<Throwable, CommitArgs> commitFailure, Executor executor) {
            this.beforeCommit = beforeCommit;
            this.commitSuccess = commitSuccess;
            this.commitFailure = commitFailure;
            this.executor = executor;
        }
    }

    static class CommitArgs {
        private final long lastFullySerializedSequenceNumber;
        private final long lastStartedSequenceNumber;
        private final AtomicReference<LogAddress> logAddress;
        private final int dataFrameLength;
        private long metadataTransactionId;
        private List<CompletableOperation> operations;

        private CommitArgs(long lastFullySerializedSequenceNumber, long lastStartedSequenceNumber, int dataFrameLength) {
            assert (lastFullySerializedSequenceNumber <= lastStartedSequenceNumber) : "lastFullySerializedSequenceNumber (" + lastFullySerializedSequenceNumber + ") is greater than lastStartedSequenceNumber (" + lastStartedSequenceNumber + ")";
            this.lastFullySerializedSequenceNumber = lastFullySerializedSequenceNumber;
            this.lastStartedSequenceNumber = lastStartedSequenceNumber;
            this.dataFrameLength = dataFrameLength;
            this.logAddress = new AtomicReference();
        }

        LogAddress getLogAddress() {
            return this.logAddress.get();
        }

        private void setLogAddress(LogAddress address) {
            this.logAddress.set(address);
        }

        public String toString() {
            return String.format("TxnId = %d, LastFullySerializedSN = %d, LastStartedSN = %d, Address = %s, Length = %d", this.getMetadataTransactionId(), this.getLastFullySerializedSequenceNumber(), this.getLastStartedSequenceNumber(), this.logAddress, this.getDataFrameLength());
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastFullySerializedSequenceNumber() {
            return this.lastFullySerializedSequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastStartedSequenceNumber() {
            return this.lastStartedSequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getDataFrameLength() {
            return this.dataFrameLength;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getMetadataTransactionId() {
            return this.metadataTransactionId;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setMetadataTransactionId(long metadataTransactionId) {
            this.metadataTransactionId = metadataTransactionId;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<CompletableOperation> getOperations() {
            return this.operations;
        }

        @SuppressFBWarnings(justification="generated code")
        public void setOperations(List<CompletableOperation> operations) {
            this.operations = operations;
        }
    }
}

