/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.InvalidPropertyValueException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;

public class DurableLogConfig {
    public static final Property<Integer> CHECKPOINT_MIN_COMMIT_COUNT = Property.named((String)"checkpointMinCommitCount", (Object)300);
    public static final Property<Integer> CHECKPOINT_COMMIT_COUNT = Property.named((String)"checkpointCommitCountThreshold", (Object)300);
    public static final Property<Long> CHECKPOINT_TOTAL_COMMIT_LENGTH = Property.named((String)"checkpointTotalCommitLengthThreshold", (Object)0x10000000L);
    public static final Property<Integer> START_RETRY_DELAY_MILLIS = Property.named((String)"startRetryDelayMillis", (Object)60000);
    private static final String COMPONENT_CODE = "durablelog";
    private final int checkpointMinCommitCount;
    private final int checkpointCommitCountThreshold;
    private final long checkpointTotalCommitLengthThreshold;
    private Duration startRetryDelay;

    private DurableLogConfig(TypedProperties properties) throws ConfigurationException {
        this.checkpointMinCommitCount = properties.getInt(CHECKPOINT_MIN_COMMIT_COUNT);
        this.checkpointCommitCountThreshold = properties.getInt(CHECKPOINT_COMMIT_COUNT);
        if (this.checkpointMinCommitCount > this.checkpointCommitCountThreshold) {
            throw new InvalidPropertyValueException(String.format("Property '%s' (%d) cannot be larger than Property '%s' (%d).", CHECKPOINT_MIN_COMMIT_COUNT, this.checkpointMinCommitCount, CHECKPOINT_COMMIT_COUNT, this.checkpointCommitCountThreshold));
        }
        this.checkpointTotalCommitLengthThreshold = properties.getLong(CHECKPOINT_TOTAL_COMMIT_LENGTH);
        int startRetryDelayMillis = properties.getInt(START_RETRY_DELAY_MILLIS);
        if (startRetryDelayMillis <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", START_RETRY_DELAY_MILLIS));
        }
        this.startRetryDelay = Duration.ofMillis(startRetryDelayMillis);
    }

    public static ConfigBuilder<DurableLogConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, DurableLogConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCheckpointMinCommitCount() {
        return this.checkpointMinCommitCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCheckpointCommitCountThreshold() {
        return this.checkpointCommitCountThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getCheckpointTotalCommitLengthThreshold() {
        return this.checkpointTotalCommitLengthThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getStartRetryDelay() {
        return this.startRetryDelay;
    }
}

