/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.logs.DurableLogConfig;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MetadataCheckpointPolicy {
    private final DurableLogConfig config;
    private final Runnable createCheckpointCallback;
    private final Executor executor;
    @GuardedBy(value="this")
    private int commitCount;
    @GuardedBy(value="this")
    private long accumulatedLength;

    public MetadataCheckpointPolicy(DurableLogConfig config, Runnable createCheckpointCallback, Executor executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)createCheckpointCallback, (Object)"createCheckpointCallback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.config = config;
        this.createCheckpointCallback = createCheckpointCallback;
        this.executor = executor;
        this.commitCount = 0;
        this.accumulatedLength = 0L;
    }

    public synchronized void recordCommit(int commitLength) {
        Preconditions.checkArgument((commitLength >= 0 ? 1 : 0) != 0, (Object)"commitLength must be a non-negative number.");
        ++this.commitCount;
        this.accumulatedLength += (long)commitLength;
        int minCount = this.config.getCheckpointMinCommitCount();
        int countThreshold = this.config.getCheckpointCommitCountThreshold();
        long lengthThreshold = this.config.getCheckpointTotalCommitLengthThreshold();
        if (this.commitCount >= minCount && (this.commitCount >= countThreshold || this.accumulatedLength >= lengthThreshold)) {
            this.commitCount = 0;
            this.accumulatedLength = 0L;
            this.executor.execute(this.createCheckpointCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        MetadataCheckpointPolicy metadataCheckpointPolicy = this;
        synchronized (metadataCheckpointPolicy) {
            return String.format("Count = %d/%d, Length = %d/%d", this.commitCount, this.config.getCheckpointCommitCountThreshold(), this.accumulatedLength, this.config.getCheckpointTotalCommitLengthThreshold());
        }
    }
}

