/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentMergedException;
import io.pravega.segmentstore.contracts.StreamSegmentNotSealedException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.contracts.StreamSegmentTruncatedException;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.logs.MetadataUpdateException;
import io.pravega.segmentstore.server.logs.operations.DeleteSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentSealOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentTruncateOperation;
import io.pravega.segmentstore.server.logs.operations.UpdateAttributesOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class SegmentMetadataUpdateTransaction
implements UpdateableSegmentMetadata {
    private final boolean recoveryMode;
    private final Map<UUID, Long> baseAttributeValues;
    private final Map<UUID, Long> attributeUpdates;
    private final long id;
    private final String name;
    private final int containerId;
    private long startOffset;
    private long length;
    private final long baseStorageLength;
    private long storageLength;
    private boolean sealed;
    private boolean sealedInStorage;
    private boolean merged;
    private boolean deletedInStorage;
    private boolean pinned;
    private boolean deleted;
    private long lastUsed;
    private boolean isChanged;

    SegmentMetadataUpdateTransaction(SegmentMetadata baseMetadata, boolean recoveryMode) {
        this.recoveryMode = recoveryMode;
        this.id = baseMetadata.getId();
        this.name = baseMetadata.getName();
        this.containerId = baseMetadata.getContainerId();
        this.startOffset = baseMetadata.getStartOffset();
        this.length = baseMetadata.getLength();
        this.baseStorageLength = baseMetadata.getStorageLength();
        this.storageLength = -1L;
        this.sealed = baseMetadata.isSealed();
        this.sealedInStorage = baseMetadata.isSealedInStorage();
        this.merged = baseMetadata.isMerged();
        this.deletedInStorage = baseMetadata.isDeletedInStorage();
        this.deleted = baseMetadata.isDeleted();
        this.baseAttributeValues = baseMetadata.getAttributes();
        this.attributeUpdates = new HashMap<UUID, Long>();
        this.lastUsed = baseMetadata.getLastUsed();
    }

    public ImmutableDate getLastModified() {
        return new ImmutableDate();
    }

    @Override
    public long getStorageLength() {
        return this.storageLength < 0L ? this.baseStorageLength : this.storageLength;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public SegmentProperties getSnapshot() {
        throw new UnsupportedOperationException("getSnapshot() is not supported on " + this.getClass().getName());
    }

    @Override
    public Map<UUID, Long> getAttributes(BiPredicate<UUID, Long> filter) {
        throw new UnsupportedOperationException("getAttributes(BiPredicate) is not supported on " + this.getClass().getName());
    }

    @Override
    public Map<UUID, Long> getAttributes() {
        HashMap<UUID, Long> result = new HashMap<UUID, Long>(this.baseAttributeValues);
        result.putAll(this.attributeUpdates);
        return result;
    }

    @Override
    public void setStorageLength(long value) {
        this.storageLength = value;
        this.isChanged = true;
    }

    @Override
    public void setStartOffset(long value) {
        this.startOffset = value;
        this.isChanged = true;
    }

    @Override
    public void setLength(long value) {
        this.length = value;
        this.isChanged = true;
    }

    @Override
    public void markSealed() {
        this.sealed = true;
        this.isChanged = true;
    }

    @Override
    public void markSealedInStorage() {
        this.sealedInStorage = true;
        this.sealed = true;
        this.isChanged = true;
    }

    @Override
    public void markDeleted() {
        this.deleted = true;
        this.isChanged = true;
    }

    @Override
    public void markDeletedInStorage() {
        this.deletedInStorage = true;
        this.deleted = true;
        this.isChanged = true;
    }

    @Override
    public void markMerged() {
        this.merged = true;
        this.isChanged = true;
    }

    @Override
    public void markPinned() {
        this.pinned = true;
        this.isChanged = true;
    }

    @Override
    public void updateAttributes(Map<UUID, Long> attributeValues) {
        this.attributeUpdates.clear();
        this.attributeUpdates.putAll(attributeValues);
        this.isChanged = true;
    }

    @Override
    public void setLastModified(ImmutableDate date) {
    }

    @Override
    public void setLastUsed(long value) {
        this.lastUsed = value;
        this.isChanged = true;
    }

    @Override
    public void copyFrom(SegmentMetadata other) {
        throw new UnsupportedOperationException("copyFrom is not supported on " + this.getClass().getName());
    }

    void preProcessOperation(StreamSegmentAppendOperation operation) throws StreamSegmentSealedException, StreamSegmentMergedException, BadOffsetException, BadAttributeUpdateException {
        this.ensureSegmentId(operation);
        if (this.merged) {
            throw new StreamSegmentMergedException(this.name);
        }
        if (this.sealed) {
            throw new StreamSegmentSealedException(this.name);
        }
        if (!this.recoveryMode) {
            long operationOffset = operation.getStreamSegmentOffset();
            if (operationOffset >= 0L) {
                if (operationOffset != this.length) {
                    throw new BadOffsetException(this.name, this.length, operationOffset);
                }
            } else {
                operation.setStreamSegmentOffset(this.length);
            }
            this.preProcessAttributes(operation.getAttributeUpdates());
        }
    }

    void preProcessOperation(UpdateAttributesOperation operation) throws StreamSegmentSealedException, StreamSegmentMergedException, BadAttributeUpdateException {
        this.ensureSegmentId(operation);
        if (this.merged) {
            throw new StreamSegmentMergedException(this.name);
        }
        if (this.sealed) {
            throw new StreamSegmentSealedException(this.name);
        }
        if (!this.recoveryMode) {
            this.preProcessAttributes(operation.getAttributeUpdates());
        }
    }

    void preProcessOperation(StreamSegmentSealOperation operation) throws StreamSegmentSealedException, StreamSegmentMergedException {
        this.ensureSegmentId(operation);
        if (this.merged) {
            throw new StreamSegmentMergedException(this.name);
        }
        if (this.sealed) {
            throw new StreamSegmentSealedException(this.name);
        }
        if (!this.recoveryMode) {
            operation.setStreamSegmentOffset(this.length);
        }
    }

    void preProcessOperation(StreamSegmentTruncateOperation operation) throws BadOffsetException {
        this.ensureSegmentId(operation);
        if (operation.getStreamSegmentOffset() < this.startOffset || operation.getStreamSegmentOffset() > this.length) {
            String msg = String.format("Truncation Offset must be at least %d and at most %d, given %d.", this.startOffset, this.length, operation.getStreamSegmentOffset());
            throw new BadOffsetException(this.name, this.startOffset, operation.getStreamSegmentOffset(), msg);
        }
    }

    void preProcessOperation(DeleteSegmentOperation operation) {
        this.ensureSegmentId(operation);
    }

    void preProcessAsTargetSegment(MergeSegmentOperation operation, SegmentMetadataUpdateTransaction sourceMetadata) throws StreamSegmentSealedException, StreamSegmentNotSealedException, MetadataUpdateException {
        this.ensureSegmentId(operation);
        if (this.sealed) {
            throw new StreamSegmentSealedException(this.name);
        }
        if (!sourceMetadata.isSealed()) {
            throw new StreamSegmentNotSealedException(this.name);
        }
        long transLength = operation.getLength();
        if (transLength < 0L) {
            throw new MetadataUpdateException(this.containerId, "MergeSegmentOperation does not have its Source Segment Length set: " + operation.toString());
        }
        if (!this.recoveryMode) {
            operation.setStreamSegmentOffset(this.length);
        }
    }

    void preProcessAsSourceSegment(MergeSegmentOperation operation) throws StreamSegmentNotSealedException, StreamSegmentMergedException, StreamSegmentTruncatedException {
        Exceptions.checkArgument((this.id == operation.getSourceSegmentId() ? 1 : 0) != 0, (String)"operation", (String)"Invalid Operation Source Segment Id.", (Object[])new Object[0]);
        if (this.merged) {
            throw new StreamSegmentMergedException(this.name);
        }
        if (!this.sealed) {
            throw new StreamSegmentNotSealedException(this.name);
        }
        if (this.startOffset > 0L) {
            throw new StreamSegmentTruncatedException(this.name, "Segment cannot be merged because it is truncated.", null);
        }
        if (!this.recoveryMode) {
            operation.setLength(this.length);
        }
    }

    private void preProcessAttributes(Collection<AttributeUpdate> attributeUpdates) throws BadAttributeUpdateException {
        if (attributeUpdates == null) {
            return;
        }
        block7: for (AttributeUpdate u : attributeUpdates) {
            AttributeUpdateType updateType = u.getUpdateType();
            boolean hasValue = false;
            long previousValue = Long.MIN_VALUE;
            if (this.attributeUpdates.containsKey(u.getAttributeId())) {
                hasValue = true;
                previousValue = this.attributeUpdates.get(u.getAttributeId());
            } else if (this.baseAttributeValues.containsKey(u.getAttributeId())) {
                hasValue = true;
                previousValue = this.baseAttributeValues.get(u.getAttributeId());
            }
            switch (updateType) {
                case ReplaceIfGreater: {
                    if (!hasValue || u.getValue() > previousValue) continue block7;
                    throw new BadAttributeUpdateException(this.name, u, false, String.format("Expected greater than '%s'.", previousValue));
                }
                case ReplaceIfEquals: {
                    if (u.getComparisonValue() == previousValue && hasValue) continue block7;
                    throw new BadAttributeUpdateException(this.name, u, !hasValue, String.format("Expected '%s', given '%s'.", previousValue, u.getComparisonValue()));
                }
                case None: {
                    if (!hasValue) continue block7;
                    throw new BadAttributeUpdateException(this.name, u, false, String.format("Attribute value already set (%s).", previousValue));
                }
                case Accumulate: {
                    if (!hasValue) continue block7;
                    u.setValue(previousValue + u.getValue());
                    continue block7;
                }
                case Replace: {
                    continue block7;
                }
            }
            throw new BadAttributeUpdateException(this.name, u, !hasValue, "Unexpected update type: " + updateType);
        }
    }

    void acceptOperation(StreamSegmentAppendOperation operation) throws MetadataUpdateException {
        this.ensureSegmentId(operation);
        if (operation.getStreamSegmentOffset() != this.length) {
            throw new MetadataUpdateException(this.containerId, String.format("SegmentAppendOperation offset mismatch. Expected %d, actual %d.", this.length, operation.getStreamSegmentOffset()));
        }
        this.length += (long)operation.getData().getLength();
        this.acceptAttributes(operation.getAttributeUpdates());
        this.isChanged = true;
    }

    void acceptOperation(UpdateAttributesOperation operation) {
        this.ensureSegmentId(operation);
        this.acceptAttributes(operation.getAttributeUpdates());
        this.isChanged = true;
    }

    void acceptOperation(StreamSegmentSealOperation operation) throws MetadataUpdateException {
        this.ensureSegmentId(operation);
        if (operation.getStreamSegmentOffset() < 0L) {
            throw new MetadataUpdateException(this.containerId, "StreamSegmentSealOperation cannot be accepted if it hasn't been pre-processed: " + operation);
        }
        this.sealed = true;
        this.isChanged = true;
    }

    void acceptOperation(StreamSegmentTruncateOperation operation) {
        this.ensureSegmentId(operation);
        this.startOffset = operation.getStreamSegmentOffset();
        this.isChanged = true;
    }

    void acceptOperation(DeleteSegmentOperation operation) {
        this.ensureSegmentId(operation);
        this.deleted = true;
        this.isChanged = true;
    }

    void acceptAsTargetSegment(MergeSegmentOperation operation, SegmentMetadataUpdateTransaction sourceMetadata) throws MetadataUpdateException {
        this.ensureSegmentId(operation);
        if (operation.getStreamSegmentOffset() != this.length) {
            throw new MetadataUpdateException(this.containerId, String.format("MergeSegmentOperation target offset mismatch. Expected %d, actual %d.", this.length, operation.getStreamSegmentOffset()));
        }
        long transLength = operation.getLength();
        if (transLength < 0L || transLength != sourceMetadata.length) {
            throw new MetadataUpdateException(this.containerId, "MergeSegmentOperation does not seem to have been pre-processed: " + operation.toString());
        }
        this.length += transLength;
        this.isChanged = true;
    }

    void acceptAsSourceSegment(MergeSegmentOperation operation) {
        Exceptions.checkArgument((this.id == operation.getSourceSegmentId() ? 1 : 0) != 0, (String)"operation", (String)"Invalid Operation Source Segment Id.", (Object[])new Object[0]);
        this.sealed = true;
        this.merged = true;
        this.isChanged = true;
    }

    private void acceptAttributes(Collection<AttributeUpdate> attributeUpdates) {
        if (attributeUpdates == null) {
            return;
        }
        for (AttributeUpdate au : attributeUpdates) {
            this.attributeUpdates.put(au.getAttributeId(), au.getValue());
        }
    }

    void updateStorageState(long storageLength, boolean storageSealed, boolean deleted, boolean storageDeleted) {
        this.storageLength = storageLength;
        this.sealedInStorage = storageSealed;
        this.deleted = deleted;
        this.deletedInStorage = storageDeleted;
        this.isChanged = true;
    }

    void apply(UpdateableSegmentMetadata target) {
        if (!this.isChanged) {
            return;
        }
        Preconditions.checkArgument((target.getId() == this.id ? 1 : 0) != 0, (String)"Target Segment Id mismatch. Expected %s, given %s.", (long)this.id, (long)target.getId());
        Preconditions.checkArgument((boolean)target.getName().equals(this.name), (String)"Target Segment Name mismatch. Expected %s, given %s.", (Object)this.name, (Object)target.getName());
        target.setLastUsed(this.lastUsed);
        target.updateAttributes(this.attributeUpdates);
        target.setLength(this.length);
        target.setStartOffset(this.startOffset);
        if (this.storageLength >= 0L) {
            target.setStorageLength(this.storageLength);
        }
        if (this.sealed) {
            target.markSealed();
            if (this.sealedInStorage) {
                target.markSealedInStorage();
            }
        }
        if (this.merged) {
            target.markMerged();
        }
        if (this.deleted) {
            target.markDeleted();
            if (this.deletedInStorage) {
                target.markDeletedInStorage();
            }
        }
        if (this.pinned) {
            target.markPinned();
        }
    }

    private void ensureSegmentId(SegmentOperation operation) {
        Exceptions.checkArgument((this.id == operation.getStreamSegmentId() ? 1 : 0) != 0, (String)"operation", (String)"Invalid Log Operation Segment Id.", (Object[])new Object[0]);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int getContainerId() {
        return this.containerId;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getStartOffset() {
        return this.startOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getLength() {
        return this.length;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isSealedInStorage() {
        return this.sealedInStorage;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isDeletedInStorage() {
        return this.deletedInStorage;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isPinned() {
        return this.pinned;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getLastUsed() {
        return this.lastUsed;
    }
}

