/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import java.util.Collection;

public class CachedStreamSegmentAppendOperation
extends StorageOperation
implements AttributeUpdaterOperation {
    private final int length;
    private final long streamSegmentOffset;
    private final Collection<AttributeUpdate> attributeUpdates;

    public CachedStreamSegmentAppendOperation(StreamSegmentAppendOperation baseOperation) {
        super(baseOperation.getStreamSegmentId());
        Preconditions.checkArgument((baseOperation.getStreamSegmentOffset() >= 0L ? 1 : 0) != 0, (Object)"given baseOperation does not have an assigned StreamSegment Offset.");
        this.streamSegmentOffset = baseOperation.getStreamSegmentOffset();
        this.length = baseOperation.getData().getLength();
        if (baseOperation.getSequenceNumber() >= 0L) {
            this.setSequenceNumber(baseOperation.getSequenceNumber());
        }
        this.attributeUpdates = baseOperation.getAttributeUpdates();
    }

    @Override
    public Collection<AttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    public String toString() {
        return String.format("%s, Offset = %d, Length = %d, Attributes = %d", super.toString(), this.streamSegmentOffset, this.length, this.attributeUpdates == null ? 0 : this.attributeUpdates.size());
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return this.length;
    }
}

