/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;

public class DeleteSegmentOperation
extends StorageOperation {
    private long streamSegmentId;
    private long streamSegmentOffset;

    public DeleteSegmentOperation(long segmentId) {
        this.streamSegmentId = segmentId;
    }

    private DeleteSegmentOperation() {
    }

    public void setStreamSegmentOffset(long value) {
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"StreamSegment Offset must be a non-negative number.", (Object[])new Object[0]);
        this.streamSegmentOffset = value;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public String toString() {
        return String.format("%s, SegmentId = %d", super.toString(), this.getStreamSegmentId());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    static class Serializer
    extends Operation.OperationSerializer<DeleteSegmentOperation> {
        private static final int SERIALIZATION_LENGTH = 24;

        Serializer() {
        }

        protected Operation.OperationBuilder<DeleteSegmentOperation> newBuilder() {
            return new Operation.OperationBuilder<DeleteSegmentOperation>(new DeleteSegmentOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(DeleteSegmentOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.streamSegmentId > 0L ? 1 : 0) != 0, (Object)"SegmentId has not been assigned.");
        }

        private void write00(DeleteSegmentOperation o, RevisionDataOutput target) throws IOException {
            target.length(24);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.getStreamSegmentOffset());
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<DeleteSegmentOperation> b) throws IOException {
            ((DeleteSegmentOperation)b.instance).setSequenceNumber(source.readLong());
            ((DeleteSegmentOperation)b.instance).streamSegmentId = source.readLong();
            ((DeleteSegmentOperation)b.instance).streamSegmentOffset = source.readLong();
        }
    }
}

