/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;

public class MergeSegmentOperation
extends StorageOperation {
    private long streamSegmentOffset;
    private long length;
    private long sourceSegmentId;

    public MergeSegmentOperation(long targetSegmentId, long sourceSegmentId) {
        super(targetSegmentId);
        this.sourceSegmentId = sourceSegmentId;
        this.length = -1L;
        this.streamSegmentOffset = -1L;
    }

    private MergeSegmentOperation() {
    }

    public long getSourceSegmentId() {
        return this.sourceSegmentId;
    }

    public void setLength(long value) {
        this.length = value;
    }

    public void setStreamSegmentOffset(long value) {
        this.streamSegmentOffset = value;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return String.format("%s, SourceSegmentId = %d, Length = %s, MergeOffset = %s", super.toString(), this.getSourceSegmentId(), this.toString(this.getLength(), -1), this.toString(this.getStreamSegmentOffset(), -1));
    }

    static class Serializer
    extends Operation.OperationSerializer<MergeSegmentOperation> {
        private static final int SERIALIZATION_LENGTH = 40;

        Serializer() {
        }

        protected Operation.OperationBuilder<MergeSegmentOperation> newBuilder() {
            return new Operation.OperationBuilder<MergeSegmentOperation>(new MergeSegmentOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(MergeSegmentOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.length >= 0L ? 1 : 0) != 0, (Object)"Source StreamSegment Length has not been assigned.");
            Preconditions.checkState((o.streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"Target StreamSegment Offset has not been assigned.");
        }

        private void write00(MergeSegmentOperation o, RevisionDataOutput target) throws IOException {
            target.length(40);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.sourceSegmentId);
            target.writeLong(o.length);
            target.writeLong(o.streamSegmentOffset);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<MergeSegmentOperation> b) throws IOException {
            ((MergeSegmentOperation)b.instance).setSequenceNumber(source.readLong());
            ((MergeSegmentOperation)b.instance).setStreamSegmentId(source.readLong());
            ((MergeSegmentOperation)b.instance).sourceSegmentId = source.readLong();
            ((MergeSegmentOperation)b.instance).length = source.readLong();
            ((MergeSegmentOperation)b.instance).streamSegmentOffset = source.readLong();
        }
    }
}

