/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.MetadataOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.io.IOException;
import java.util.Collection;

public class UpdateAttributesOperation
extends MetadataOperation
implements AttributeUpdaterOperation {
    private long streamSegmentId;
    private Collection<AttributeUpdate> attributeUpdates;

    public UpdateAttributesOperation(long streamSegmentId, Collection<AttributeUpdate> attributeUpdates) {
        Preconditions.checkNotNull(attributeUpdates, (Object)"attributeUpdates");
        this.streamSegmentId = streamSegmentId;
        this.attributeUpdates = attributeUpdates;
    }

    private UpdateAttributesOperation() {
    }

    @Override
    public String toString() {
        return String.format("%s, SegmentId = %d, Attributes = %d", super.toString(), this.streamSegmentId, this.attributeUpdates.size());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Collection<AttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    static class Serializer
    extends Operation.OperationSerializer<UpdateAttributesOperation> {
        private static final int STATIC_LENGTH = 16;
        private static final int ATTRIBUTE_UPDATE_LENGTH = 33;

        Serializer() {
        }

        protected Operation.OperationBuilder<UpdateAttributesOperation> newBuilder() {
            return new Operation.OperationBuilder<UpdateAttributesOperation>(new UpdateAttributesOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(UpdateAttributesOperation o, RevisionDataOutput target) throws IOException {
            int attributesLength = o.attributeUpdates == null ? target.getCompactIntLength(0) : target.getCollectionLength(o.attributeUpdates.size(), 33);
            target.length(16 + attributesLength);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.streamSegmentId);
            target.writeCollection(o.attributeUpdates, this::writeAttributeUpdate00);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<UpdateAttributesOperation> b) throws IOException {
            ((UpdateAttributesOperation)b.instance).setSequenceNumber(source.readLong());
            ((UpdateAttributesOperation)b.instance).streamSegmentId = source.readLong();
            ((UpdateAttributesOperation)b.instance).attributeUpdates = source.readCollection(this::readAttributeUpdate00);
        }

        private void writeAttributeUpdate00(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeUUID(au.getAttributeId());
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
            target.writeLong(au.getComparisonValue());
        }

        private AttributeUpdate readAttributeUpdate00(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(source.readUUID(), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), source.readLong());
        }
    }
}

