/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.mocks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.MergeStreamSegmentResult;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class SynchronousStreamSegmentStore
implements StreamSegmentStore {
    private final StreamSegmentStore impl;

    public CompletableFuture<Long> append(String streamSegmentName, BufferView data, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        CompletableFuture result = this.impl.append(streamSegmentName, data, attributeUpdates, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Long> append(String streamSegmentName, long offset, BufferView data, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        CompletableFuture result = this.impl.append(streamSegmentName, offset, data, attributeUpdates, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Void> updateAttributes(String streamSegmentName, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        CompletableFuture result = this.impl.updateAttributes(streamSegmentName, attributeUpdates, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Map<UUID, Long>> getAttributes(String streamSegmentName, Collection<UUID> attributeIds, boolean cache, Duration timeout) {
        CompletableFuture result = this.impl.getAttributes(streamSegmentName, attributeIds, cache, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<ReadResult> read(String streamSegmentName, long offset, int maxLength, Duration timeout) {
        CompletableFuture result = this.impl.read(streamSegmentName, offset, maxLength, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        CompletableFuture result = this.impl.getStreamSegmentInfo(streamSegmentName, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Void> createStreamSegment(String streamSegmentName, Collection<AttributeUpdate> attributes, Duration timeout) {
        CompletableFuture result = this.impl.createStreamSegment(streamSegmentName, attributes, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, Duration timeout) {
        CompletableFuture result = this.impl.mergeStreamSegment(targetStreamSegment, sourceStreamSegment, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Long> sealStreamSegment(String streamSegmentName, Duration timeout) {
        CompletableFuture result = this.impl.sealStreamSegment(streamSegmentName, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Void> deleteStreamSegment(String streamSegmentName, Duration timeout) {
        CompletableFuture result = this.impl.deleteStreamSegment(streamSegmentName, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    public CompletableFuture<Void> truncateStreamSegment(String streamSegmentName, long offset, Duration timeout) {
        CompletableFuture result = this.impl.truncateStreamSegment(streamSegmentName, offset, timeout);
        Futures.await((CompletableFuture)result);
        return result;
    }

    @ConstructorProperties(value={"impl"})
    @SuppressFBWarnings(justification="generated code")
    public SynchronousStreamSegmentStore(StreamSegmentStore impl) {
        this.impl = impl;
    }
}

