/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.BitConverter;
import io.pravega.segmentstore.storage.Cache;

class CacheKey
extends Cache.Key {
    private static final HashHelper HASH = HashHelper.seededWith((String)CacheKey.class.getName());
    private static final int SERIALIZATION_LENGTH = 16;
    private final long streamSegmentId;
    private final long offset;

    CacheKey(long streamSegmentId, long offset) {
        Preconditions.checkArgument((streamSegmentId != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"streamSegmentId");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset");
        this.streamSegmentId = streamSegmentId;
        this.offset = offset;
    }

    @VisibleForTesting
    CacheKey(byte[] serialization) {
        Preconditions.checkNotNull((Object)serialization, (Object)"serialization");
        Preconditions.checkArgument((serialization.length == 16 ? 1 : 0) != 0, (Object)"Invalid serialization length.");
        this.streamSegmentId = BitConverter.readLong((byte[])serialization, (int)0);
        this.offset = BitConverter.readLong((byte[])serialization, (int)8);
    }

    public byte[] serialize() {
        byte[] result = new byte[16];
        BitConverter.writeLong((byte[])result, (int)0, (long)this.streamSegmentId);
        BitConverter.writeLong((byte[])result, (int)8, (long)this.offset);
        return result;
    }

    public int hashCode() {
        return HASH.hash(this.offset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)((Object)obj);
        return this.streamSegmentId == other.streamSegmentId && this.offset == other.offset;
    }

    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return String.format("SegmentId = %d, Offset = %d", this.streamSegmentId, this.offset);
    }
}

