/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import io.pravega.common.function.Callbacks;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.server.reading.ReadResultEntryBase;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

class FutureReadResultEntry
extends ReadResultEntryBase {
    @GuardedBy(value="this")
    private Consumer<FutureReadResultEntry> onCompleteOrFail;

    FutureReadResultEntry(long streamSegmentOffset, int requestedReadLength) {
        super(ReadResultEntryType.Future, streamSegmentOffset, requestedReadLength);
    }

    synchronized void setOnCompleteOrFail(Consumer<FutureReadResultEntry> callback) {
        this.onCompleteOrFail = callback;
    }

    @Override
    protected void complete(ReadResultEntryContents readResultEntryContents) {
        super.complete(readResultEntryContents);
        this.invokeWhenCompleteOrFail();
    }

    @Override
    public void fail(Throwable exception) {
        super.fail(exception);
        this.invokeWhenCompleteOrFail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeWhenCompleteOrFail() {
        Consumer<FutureReadResultEntry> callback;
        FutureReadResultEntry futureReadResultEntry = this;
        synchronized (futureReadResultEntry) {
            callback = this.onCompleteOrFail;
        }
        if (callback != null) {
            Callbacks.invokeSafely(callback, (Object)this, null);
        }
    }
}

