/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.reading.CacheIndexEntry;

class MergedIndexEntry
extends CacheIndexEntry {
    private final long sourceSegmentId;
    private final long sourceSegmentOffset;

    MergedIndexEntry(long streamSegmentOffset, long sourceSegmentId, CacheIndexEntry sourceEntry) {
        super(streamSegmentOffset, (int)sourceEntry.getLength());
        Preconditions.checkArgument((sourceSegmentId != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"sourceSegmentId");
        Preconditions.checkArgument((sourceEntry.getStreamSegmentOffset() >= 0L ? 1 : 0) != 0, (Object)"streamSegmentOffset must be a non-negative number.");
        this.sourceSegmentId = sourceSegmentId;
        this.sourceSegmentOffset = sourceEntry.getStreamSegmentOffset();
        this.setGeneration(sourceEntry.getGeneration());
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSourceSegmentId() {
        return this.sourceSegmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSourceSegmentOffset() {
        return this.sourceSegmentOffset;
    }
}

