/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.CacheManager;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ReadIndexSummary {
    @GuardedBy(value="this")
    private int currentGeneration = 0;
    @GuardedBy(value="this")
    private long totalSize = 0L;
    @GuardedBy(value="this")
    private final HashMap<Integer, Integer> generations = new HashMap();

    ReadIndexSummary() {
    }

    synchronized void setCurrentGeneration(int generation) {
        Preconditions.checkArgument((generation >= this.currentGeneration ? 1 : 0) != 0, (Object)"New generation must be at least the value of the previous one.");
        this.currentGeneration = generation;
    }

    synchronized int add(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be a non-negative number");
        this.totalSize += size;
        this.addToCurrentGeneration();
        return this.currentGeneration;
    }

    synchronized void add(long size, int generation) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be a non-negative number");
        Preconditions.checkArgument((generation >= 0 ? 1 : 0) != 0, (Object)"generation must be a non-negative number");
        this.totalSize += size;
        int newCount = this.generations.getOrDefault(generation, 0) + 1;
        this.generations.put(generation, newCount);
    }

    synchronized void remove(long size, int generation) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be a non-negative number");
        this.totalSize -= size;
        if (this.totalSize < 0L) {
            this.totalSize = 0L;
        }
        this.removeFromGeneration(generation);
    }

    synchronized int touchOne(int generation) {
        this.removeFromGeneration(generation);
        this.addToCurrentGeneration();
        return this.currentGeneration;
    }

    synchronized CacheManager.CacheStatus toCacheStatus() {
        AtomicInteger oldestGeneration = new AtomicInteger(Integer.MAX_VALUE);
        AtomicInteger newestGeneration = new AtomicInteger(0);
        this.generations.keySet().forEach(g -> {
            if (oldestGeneration.get() > g) {
                oldestGeneration.set((int)g);
            }
            if (newestGeneration.get() < g) {
                newestGeneration.set((int)g);
            }
        });
        return new CacheManager.CacheStatus(this.totalSize, Math.min(newestGeneration.get(), oldestGeneration.get()), newestGeneration.get());
    }

    @GuardedBy(value="this")
    private void addToCurrentGeneration() {
        int newCount = this.generations.getOrDefault(this.currentGeneration, 0) + 1;
        this.generations.put(this.currentGeneration, newCount);
    }

    @GuardedBy(value="this")
    private void removeFromGeneration(int generation) {
        int newCount = this.generations.getOrDefault(generation, 0) - 1;
        if (newCount > 0) {
            this.generations.put(generation, newCount);
        } else {
            this.generations.remove(generation);
        }
    }
}

