/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class StreamSegmentReadResult
implements ReadResult {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentReadResult.class);
    private final String traceObjectId;
    private final long streamSegmentStartOffset;
    private final int maxResultLength;
    private final NextEntrySupplier getNextItem;
    @GuardedBy(value="this")
    private CompletableReadResultEntry lastEntry;
    @GuardedBy(value="this")
    private int consumedLength;
    @GuardedBy(value="this")
    private boolean canRead;
    @GuardedBy(value="this")
    private boolean closed;

    StreamSegmentReadResult(long streamSegmentStartOffset, int maxResultLength, @NonNull NextEntrySupplier getNextItem, String traceObjectId) {
        if (getNextItem == null) {
            throw new NullPointerException("getNextItem is marked @NonNull but is null");
        }
        Exceptions.checkArgument((streamSegmentStartOffset >= 0L ? 1 : 0) != 0, (String)"streamSegmentStartOffset", (String)"streamSegmentStartOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((maxResultLength >= 0 ? 1 : 0) != 0, (String)"maxResultLength", (String)"maxResultLength must be a non-negative number.", (Object[])new Object[0]);
        this.traceObjectId = traceObjectId;
        this.streamSegmentStartOffset = streamSegmentStartOffset;
        this.maxResultLength = maxResultLength;
        this.getNextItem = getNextItem;
        this.consumedLength = 0;
        this.canRead = true;
    }

    public long getStreamSegmentStartOffset() {
        return this.streamSegmentStartOffset;
    }

    public int getMaxResultLength() {
        return this.maxResultLength;
    }

    public synchronized int getConsumedLength() {
        return this.consumedLength;
    }

    public synchronized boolean isClosed() {
        return this.closed || !this.hasNext();
    }

    public String toString() {
        return String.format("Offset = %d, MaxLength = %d, Consumed = %d", this.streamSegmentStartOffset, this.maxResultLength, this.getConsumedLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CompletableReadResultEntry lastEntry = null;
        StreamSegmentReadResult streamSegmentReadResult = this;
        synchronized (streamSegmentReadResult) {
            if (!this.closed) {
                this.closed = true;
                lastEntry = this.lastEntry;
                this.lastEntry = null;
                log.trace("{}.ReadResult[{}]: Closed.", (Object)this.traceObjectId, (Object)this.streamSegmentStartOffset);
            }
        }
        if (lastEntry != null && !lastEntry.isDone()) {
            lastEntry.fail(new CancellationException(String.format("ReadResult[%s] closed.", this.traceObjectId)));
            log.trace("{}.ReadResult[{}]: Cancelled last entry '{}'.", new Object[]{this.traceObjectId, this.streamSegmentStartOffset, lastEntry});
        }
    }

    public synchronized boolean hasNext() {
        return !this.closed && this.canRead && this.consumedLength < this.maxResultLength;
    }

    public synchronized ReadResultEntry next() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.lastEntry == null || this.lastEntry.isDone() ? 1 : 0) != 0, (Object)"Cannot request a new entry when the previous one hasn't completed retrieval yet.");
        if (!this.hasNext()) {
            return null;
        }
        long startOffset = this.streamSegmentStartOffset + (long)this.consumedLength;
        int remainingLength = this.maxResultLength - this.consumedLength;
        CompletableReadResultEntry entry = (CompletableReadResultEntry)this.getNextItem.apply(startOffset, remainingLength);
        if (entry == null) {
            assert (remainingLength <= 0) : String.format("No ReadResultEntry received when one was expected. Offset %d, MaxLen %d.", startOffset, remainingLength);
            this.lastEntry = null;
        } else {
            assert (entry.getStreamSegmentOffset() == startOffset) : String.format("Invalid ReadResultEntry. Expected offset %d, given %d.", startOffset, entry.getStreamSegmentOffset());
            if (entry.getType().isTerminal()) {
                this.lastEntry = null;
                this.canRead = false;
            } else {
                entry.setCompletionCallback(length -> {
                    StreamSegmentReadResult streamSegmentReadResult = this;
                    synchronized (streamSegmentReadResult) {
                        this.consumedLength += length.intValue();
                    }
                });
                this.lastEntry = entry;
                Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            }
        }
        log.trace("{}.ReadResult[{}]: Consumed = {}, MaxLength = {}, Entry = ({}).", new Object[]{this.traceObjectId, this.streamSegmentStartOffset, this.consumedLength, this.maxResultLength, entry});
        return entry;
    }

    @FunctionalInterface
    static interface NextEntrySupplier
    extends BiFunction<Long, Integer, CompletableReadResultEntry> {
    }
}

