/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Services;
import io.pravega.common.function.Callbacks;
import io.pravega.segmentstore.contracts.ContainerNotFoundException;
import io.pravega.segmentstore.server.ContainerHandle;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerFactory;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamSegmentContainerRegistry
implements SegmentContainerRegistry {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentContainerRegistry.class);
    private final SegmentContainerFactory factory;
    private final ConcurrentHashMap<Integer, ContainerWithHandle> containers;
    private final Executor executor;
    private final AtomicBoolean closed;

    StreamSegmentContainerRegistry(SegmentContainerFactory containerFactory, Executor executor) {
        Preconditions.checkNotNull((Object)containerFactory, (Object)"containerFactory");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.factory = containerFactory;
        this.executor = executor;
        this.containers = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ArrayList<ContainerWithHandle> toClose = new ArrayList<ContainerWithHandle>(this.containers.values());
            for (ContainerWithHandle c : toClose) {
                c.container.close();
            }
        }
    }

    @Override
    public int getContainerCount() {
        return this.containers.size();
    }

    @Override
    public SegmentContainer getContainer(int containerId) throws ContainerNotFoundException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ContainerWithHandle result = this.containers.getOrDefault(containerId, null);
        if (result == null || Services.isTerminating((Service.State)result.container.state())) {
            throw new ContainerNotFoundException(containerId);
        }
        return result.container;
    }

    @Override
    public CompletableFuture<ContainerHandle> startContainer(int containerId, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ContainerWithHandle existingContainer = this.containers.get(containerId);
        if (existingContainer != null) {
            if (!Services.isTerminating((Service.State)existingContainer.container.state())) {
                throw new IllegalArgumentException(String.format("Container %d is already registered.", containerId));
            }
            return existingContainer.shutdownNotifier.thenComposeAsync(v -> this.startContainerInternal(containerId), this.executor);
        }
        return this.startContainerInternal(containerId);
    }

    @Override
    public CompletableFuture<Void> stopContainer(ContainerHandle handle, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ContainerWithHandle result = this.containers.getOrDefault(handle.getContainerId(), null);
        if (result == null) {
            return CompletableFuture.completedFuture(null);
        }
        return Services.stopAsync((Service)result.container, (Executor)this.executor);
    }

    private CompletableFuture<ContainerHandle> startContainerInternal(int containerId) {
        ContainerWithHandle newContainer = new ContainerWithHandle(this.factory.createStreamSegmentContainer(containerId), new SegmentContainerHandle(containerId));
        ContainerWithHandle existingContainer = this.containers.putIfAbsent(containerId, newContainer);
        if (existingContainer != null) {
            newContainer.container.close();
            throw new IllegalArgumentException(String.format("Container %d is already registered.", containerId));
        }
        log.info("Registered SegmentContainer {}.", (Object)containerId);
        Services.onStop((Service)newContainer.container, () -> this.unregisterContainer(newContainer), ex -> this.handleContainerFailure(newContainer, (Throwable)ex), (Executor)this.executor);
        return Services.startAsync((Service)newContainer.container, (Executor)this.executor).thenApply(v -> newContainer.handle);
    }

    private void handleContainerFailure(ContainerWithHandle containerWithHandle, Throwable exception) {
        this.unregisterContainer(containerWithHandle);
        log.error("Critical failure for SegmentContainer {}. {}", (Object)containerWithHandle, (Object)exception);
    }

    private void unregisterContainer(ContainerWithHandle containerWithHandle) {
        assert (containerWithHandle != null) : "containerWithHandle is null.";
        assert (containerWithHandle.container.state() == Service.State.TERMINATED || containerWithHandle.container.state() == Service.State.FAILED) : "Container is not stopped.";
        containerWithHandle.container.close();
        this.containers.remove(containerWithHandle.handle.getContainerId());
        containerWithHandle.handle.notifyContainerStopped();
        log.info("Unregistered SegmentContainer {}.", (Object)containerWithHandle.handle.getContainerId());
        containerWithHandle.shutdownNotifier.complete(null);
    }

    private static class SegmentContainerHandle
    implements ContainerHandle {
        private final int containerId;
        private Consumer<Integer> containerStoppedListener;

        void notifyContainerStopped() {
            Consumer<Integer> handler = this.containerStoppedListener;
            if (handler != null) {
                Callbacks.invokeSafely(handler, (Object)this.containerId, null);
            }
        }

        public String toString() {
            return String.format("SegmentContainerId = %d", this.containerId);
        }

        @ConstructorProperties(value={"containerId"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentContainerHandle(int containerId) {
            this.containerId = containerId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int getContainerId() {
            return this.containerId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public void setContainerStoppedListener(Consumer<Integer> containerStoppedListener) {
            this.containerStoppedListener = containerStoppedListener;
        }
    }

    private static class ContainerWithHandle {
        final SegmentContainer container;
        final SegmentContainerHandle handle;
        final CompletableFuture<Void> shutdownNotifier = new CompletableFuture();

        public String toString() {
            return String.format("Container Id = %d, State = %s", this.container.getId(), this.container.state());
        }

        @ConstructorProperties(value={"container", "handle"})
        @SuppressFBWarnings(justification="generated code")
        public ContainerWithHandle(SegmentContainer container, SegmentContainerHandle handle) {
            this.container = container;
            this.handle = handle;
        }
    }
}

