/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.MergeStreamSegmentResult;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.store.SegmentContainerCollection;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSegmentService
extends SegmentContainerCollection
implements StreamSegmentStore {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentService.class);

    public StreamSegmentService(SegmentContainerRegistry segmentContainerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        super(segmentContainerRegistry, segmentToContainerMapper);
    }

    public CompletableFuture<Long> append(String streamSegmentName, BufferView data, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.append(streamSegmentName, data, attributeUpdates, timeout), "append", streamSegmentName, data.getLength(), attributeUpdates);
    }

    public CompletableFuture<Long> append(String streamSegmentName, long offset, BufferView data, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.append(streamSegmentName, offset, data, attributeUpdates, timeout), "appendWithOffset", streamSegmentName, offset, data.getLength(), attributeUpdates);
    }

    public CompletableFuture<Void> updateAttributes(String streamSegmentName, Collection<AttributeUpdate> attributeUpdates, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.updateAttributes(streamSegmentName, attributeUpdates, timeout), "updateAttributes", streamSegmentName, attributeUpdates);
    }

    public CompletableFuture<Map<UUID, Long>> getAttributes(String streamSegmentName, Collection<UUID> attributeIds, boolean cache, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.getAttributes(streamSegmentName, attributeIds, cache, timeout), "getAttributes", streamSegmentName, attributeIds);
    }

    public CompletableFuture<ReadResult> read(String streamSegmentName, long offset, int maxLength, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.read(streamSegmentName, offset, maxLength, timeout), "read", streamSegmentName, offset, maxLength);
    }

    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.getStreamSegmentInfo(streamSegmentName, timeout), "getStreamSegmentInfo", streamSegmentName);
    }

    public CompletableFuture<Void> createStreamSegment(String streamSegmentName, Collection<AttributeUpdate> attributes, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.createStreamSegment(streamSegmentName, attributes, timeout), "createStreamSegment", streamSegmentName, attributes);
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, Duration timeout) {
        return this.invoke(sourceStreamSegment, container -> container.mergeStreamSegment(targetStreamSegment, sourceStreamSegment, timeout), "mergeTransaction", targetStreamSegment, sourceStreamSegment);
    }

    public CompletableFuture<Long> sealStreamSegment(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.sealStreamSegment(streamSegmentName, timeout), "sealStreamSegment", streamSegmentName);
    }

    public CompletableFuture<Void> deleteStreamSegment(String streamSegmentName, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.deleteStreamSegment(streamSegmentName, timeout), "deleteStreamSegment", streamSegmentName);
    }

    public CompletableFuture<Void> truncateStreamSegment(String streamSegmentName, long offset, Duration timeout) {
        return this.invoke(streamSegmentName, container -> container.truncateStreamSegment(streamSegmentName, offset, timeout), "truncateStreamSegment", streamSegmentName);
    }
}

