/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.io.EnhancedByteArrayOutputStream;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.StreamHelpers;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.reading.AsyncReadResultHandler;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

abstract class AsyncTableEntryReader<ResultT>
implements AsyncReadResultHandler {
    private final TimeoutTimer timer;
    private final EnhancedByteArrayOutputStream readData;
    private final CompletableFuture<ResultT> result;
    private final EntrySerializer serializer;
    private EntrySerializer.Header header;
    private final long keyVersion;

    private AsyncTableEntryReader(long keyVersion, @NonNull EntrySerializer serializer, @NonNull TimeoutTimer timer) {
        if (serializer == null) {
            throw new NullPointerException("serializer is marked @NonNull but is null");
        }
        if (timer == null) {
            throw new NullPointerException("timer is marked @NonNull but is null");
        }
        this.keyVersion = keyVersion;
        this.serializer = serializer;
        this.timer = timer;
        this.readData = new EnhancedByteArrayOutputStream();
        this.result = new CompletableFuture();
    }

    static AsyncTableEntryReader<TableEntry> readEntry(ArrayView soughtKey, long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
        return new EntryReader(soughtKey, keyVersion, serializer, timer);
    }

    static AsyncTableEntryReader<TableKey> readKey(long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
        return new KeyReader(keyVersion, serializer, timer);
    }

    static DeserializedEntry readEntryComponents(InputStream input, long segmentOffset, EntrySerializer serializer) throws IOException {
        EntrySerializer.Header h = serializer.readHeader(input);
        long version = AsyncTableEntryReader.getKeyVersion(h, segmentOffset);
        byte[] key = StreamHelpers.readAll((InputStream)input, (int)h.getKeyLength());
        byte[] value = h.isDeletion() ? null : (h.getValueLength() == 0 ? new byte[]{} : StreamHelpers.readAll((InputStream)input, (int)h.getValueLength()));
        return new DeserializedEntry(h, version, key, value);
    }

    protected abstract boolean processReadData(ByteArraySegment var1);

    protected void complete(ResultT result) {
        this.result.complete(result);
    }

    private static long getKeyVersion(EntrySerializer.Header header, long segmentOffset) {
        return header.getEntryVersion() == Long.MIN_VALUE ? segmentOffset : header.getEntryVersion();
    }

    protected long getKeyVersion() {
        return AsyncTableEntryReader.getKeyVersion(this.header, this.keyVersion);
    }

    @Override
    public boolean shouldRequestContents(ReadResultEntryType entryType, long streamSegmentOffset) {
        return entryType == ReadResultEntryType.Cache || entryType == ReadResultEntryType.Storage || entryType == ReadResultEntryType.Future;
    }

    @Override
    public boolean processEntry(ReadResultEntry entry) {
        if (this.result.isDone()) {
            return false;
        }
        try {
            Preconditions.checkArgument((boolean)entry.getContent().isDone(), (Object)"Entry Contents is not yet fetched.");
            ReadResultEntryContents contents = (ReadResultEntryContents)entry.getContent().join();
            this.readData.write(StreamHelpers.readAll((InputStream)contents.getData(), (int)contents.getLength()));
            if (this.header == null && this.readData.size() >= 17) {
                this.header = this.serializer.readHeader((ArrayView)this.readData.getData());
            }
            if (this.header != null) {
                return !this.processReadData(this.readData.getData());
            }
            return true;
        }
        catch (Throwable ex) {
            this.processError(ex);
            return false;
        }
    }

    @Override
    public void processResultComplete() {
        if (!this.result.isDone()) {
            this.processError(new SerializationException("Reached the end of the ReadResult but unable to read desired data."));
        }
    }

    @Override
    public void processError(Throwable cause) {
        this.result.completeExceptionally(cause);
    }

    @Override
    public Duration getRequestContentTimeout() {
        return this.timer.getRemaining();
    }

    @SuppressFBWarnings(justification="generated code")
    public CompletableFuture<ResultT> getResult() {
        return this.result;
    }

    @SuppressFBWarnings(justification="generated code")
    protected EntrySerializer.Header getHeader() {
        return this.header;
    }

    static class DeserializedEntry {
        private final EntrySerializer.Header header;
        private final long version;
        private final byte[] key;
        private final byte[] value;

        @SuppressFBWarnings(justification="generated code")
        public EntrySerializer.Header getHeader() {
            return this.header;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte[] getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte[] getValue() {
            return this.value;
        }

        @ConstructorProperties(value={"header", "version", "key", "value"})
        @SuppressFBWarnings(justification="generated code")
        private DeserializedEntry(EntrySerializer.Header header, long version, byte[] key, byte[] value) {
            this.header = header;
            this.version = version;
            this.key = key;
            this.value = value;
        }
    }

    private static class EntryReader
    extends AsyncTableEntryReader<TableEntry> {
        private final ArrayView soughtKey;
        private boolean keyValidated;

        private EntryReader(ArrayView soughtKey, long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
            super(keyVersion, serializer, timer);
            this.soughtKey = soughtKey;
            this.keyValidated = soughtKey == null;
        }

        @Override
        protected boolean processReadData(ByteArraySegment readData) {
            EntrySerializer.Header header = this.getHeader();
            assert (header != null) : "acceptResult called with no header loaded.";
            if (this.soughtKey != null && header.getKeyLength() != this.soughtKey.getLength()) {
                this.complete(null);
                return false;
            }
            if (readData.getLength() < 17 + header.getKeyLength()) {
                return false;
            }
            if (!this.keyValidated) {
                ByteArraySegment keyData = readData.subSegment(header.getKeyOffset(), header.getKeyLength());
                for (int i = 0; i < this.soughtKey.getLength(); ++i) {
                    if (this.soughtKey.get(i) == keyData.get(i)) continue;
                    this.complete(null);
                    return true;
                }
                this.keyValidated = true;
            }
            if (header.isDeletion()) {
                this.complete(TableEntry.notExists((ArrayView)this.getKeyData(this.soughtKey, readData, header)));
                return true;
            }
            if (readData.getLength() < header.getTotalLength()) {
                return false;
            }
            ByteArraySegment valueData = header.getValueLength() == 0 ? new ByteArraySegment(new byte[0]) : readData.subSegment(header.getValueOffset(), header.getValueLength());
            this.complete(TableEntry.versioned((ArrayView)this.getKeyData(this.soughtKey, readData, header), (ArrayView)valueData, (long)this.getKeyVersion()));
            return true;
        }

        private ArrayView getKeyData(ArrayView soughtKey, ByteArraySegment readData, EntrySerializer.Header header) {
            if (soughtKey == null) {
                soughtKey = readData.subSegment(header.getKeyOffset(), header.getKeyLength());
            }
            return soughtKey;
        }
    }

    private static class KeyReader
    extends AsyncTableEntryReader<TableKey> {
        KeyReader(long keyVersion, EntrySerializer serializer, TimeoutTimer timer) {
            super(keyVersion, serializer, timer);
        }

        @Override
        protected boolean processReadData(ByteArraySegment readData) {
            EntrySerializer.Header header = this.getHeader();
            assert (header != null) : "acceptResult called with no header loaded.";
            if (readData.getLength() >= 17 + header.getKeyLength()) {
                ByteArraySegment keyData = readData.subSegment(header.getKeyOffset(), header.getKeyLength());
                if (header.isDeletion()) {
                    this.complete(TableKey.notExists((ArrayView)keyData));
                } else {
                    this.complete(TableKey.versioned((ArrayView)keyData, (long)this.getKeyVersion()));
                }
                return true;
            }
            return false;
        }
    }
}

