/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Runnables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.IllegalDataFormatException;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.StreamSegmentTruncatedException;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.ContainerKeyIndex;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import io.pravega.segmentstore.server.tables.IteratorState;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucketReader;
import io.pravega.segmentstore.server.tables.TableIterator;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.server.tables.TableWriterConnector;
import io.pravega.segmentstore.server.tables.WriterTableProcessor;
import io.pravega.segmentstore.storage.CacheFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTableExtensionImpl
implements ContainerTableExtension {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ContainerTableExtensionImpl.class);
    private static final int MAX_BATCH_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_COMPACTION_SIZE = 0x400000;
    private final SegmentContainer segmentContainer;
    private final ScheduledExecutorService executor;
    private final KeyHasher hasher;
    private final ContainerKeyIndex keyIndex;
    private final EntrySerializer serializer;
    private final AtomicBoolean closed;
    private final String traceObjectId;

    public ContainerTableExtensionImpl(SegmentContainer segmentContainer, CacheFactory cacheFactory, CacheManager cacheManager, ScheduledExecutorService executor) {
        this(segmentContainer, cacheFactory, cacheManager, KeyHasher.sha256(), executor);
    }

    @VisibleForTesting
    ContainerTableExtensionImpl(@NonNull SegmentContainer segmentContainer, @NonNull CacheFactory cacheFactory, @NonNull CacheManager cacheManager, @NonNull KeyHasher hasher, @NonNull ScheduledExecutorService executor) {
        if (segmentContainer == null) {
            throw new NullPointerException("segmentContainer is marked @NonNull but is null");
        }
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked @NonNull but is null");
        }
        if (cacheManager == null) {
            throw new NullPointerException("cacheManager is marked @NonNull but is null");
        }
        if (hasher == null) {
            throw new NullPointerException("hasher is marked @NonNull but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.segmentContainer = segmentContainer;
        this.executor = executor;
        this.hasher = hasher;
        this.keyIndex = new ContainerKeyIndex(segmentContainer.getId(), cacheFactory, cacheManager, this.hasher, this.executor);
        this.serializer = new EntrySerializer();
        this.closed = new AtomicBoolean();
        this.traceObjectId = String.format("TableExtension[%d]", this.segmentContainer.getId());
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.keyIndex.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    @Override
    public Collection<WriterSegmentProcessor> createWriterSegmentProcessors(UpdateableSegmentMetadata metadata) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (!metadata.getAttributes().containsKey(TableAttributes.INDEX_OFFSET)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new WriterTableProcessor(new TableWriterConnectorImpl(metadata), this.executor));
    }

    public CompletableFuture<Void> createSegment(@NonNull String segmentName, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        List attributes = TableAttributes.DEFAULT_VALUES.entrySet().stream().map(e -> new AttributeUpdate((UUID)e.getKey(), AttributeUpdateType.None, ((Long)e.getValue()).longValue())).collect(Collectors.toList());
        this.logRequest("createSegment", segmentName);
        return this.segmentContainer.createStreamSegment(segmentName, attributes, timeout);
    }

    public CompletableFuture<Void> deleteSegment(@NonNull String segmentName, boolean mustBeEmpty, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        this.logRequest("deleteSegment", segmentName, mustBeEmpty);
        if (mustBeEmpty) {
            TimeoutTimer timer = new TimeoutTimer(timeout);
            return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.keyIndex.executeIfEmpty((DirectSegmentAccess)segment, () -> this.segmentContainer.deleteStreamSegment(segmentName, timer.getRemaining()), timer), (Executor)this.executor);
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentContainer.deleteStreamSegment(segmentName, timeout);
    }

    public CompletableFuture<Void> merge(@NonNull String targetSegmentName, @NonNull String sourceSegmentName, Duration timeout) {
        if (targetSegmentName == null) {
            throw new NullPointerException("targetSegmentName is marked @NonNull but is null");
        }
        if (sourceSegmentName == null) {
            throw new NullPointerException("sourceSegmentName is marked @NonNull but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        throw new UnsupportedOperationException("merge");
    }

    public CompletableFuture<Void> seal(String segmentName, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        throw new UnsupportedOperationException("seal");
    }

    public CompletableFuture<List<Long>> put(@NonNull String segmentName, @NonNull List<TableEntry> entries, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked @NonNull but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        TableKeyBatch updateBatch = this.batch(entries, TableEntry::getKey, this.serializer::getUpdateLength, TableKeyBatch.update());
        this.logRequest("put", segmentName, updateBatch.isConditional(), updateBatch.isRemoval(), entries.size(), updateBatch.getLength());
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.keyIndex.update((DirectSegmentAccess)segment, updateBatch, () -> this.commit((Collection)entries, updateBatch.getLength(), this.serializer::serializeUpdate, (DirectSegmentAccess)segment, timer.getRemaining()), timer), (Executor)this.executor);
    }

    public CompletableFuture<Void> remove(@NonNull String segmentName, @NonNull Collection<TableKey> keys, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked @NonNull but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        TableKeyBatch removeBatch = this.batch(keys, key -> key, this.serializer::getRemovalLength, TableKeyBatch.removal());
        this.logRequest("remove", segmentName, removeBatch.isConditional(), removeBatch.isRemoval(), keys.size(), removeBatch.getLength());
        return ((CompletableFuture)this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.keyIndex.update((DirectSegmentAccess)segment, removeBatch, () -> this.commit((Collection)keys, removeBatch.getLength(), this.serializer::serializeRemoval, (DirectSegmentAccess)segment, timer.getRemaining()), timer), (Executor)this.executor)).thenRun(Runnables.doNothing());
    }

    public CompletableFuture<List<TableEntry>> get(@NonNull String segmentName, @NonNull List<ArrayView> keys, Duration timeout) {
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked @NonNull but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.logRequest("get", segmentName, keys.size());
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        TimeoutTimer timer = new TimeoutTimer(timeout);
        GetResultBuilder resultBuilder = new GetResultBuilder(keys, this.hasher);
        return this.segmentContainer.forSegment(segmentName, timer.getRemaining()).thenComposeAsync(segment -> this.keyIndex.getBucketOffsets((DirectSegmentAccess)segment, (Collection<UUID>)resultBuilder.getHashes(), timer).thenComposeAsync(offsets -> this.get((DirectSegmentAccess)segment, resultBuilder, (Map<UUID, Long>)offsets, timer), (Executor)this.executor), (Executor)this.executor);
    }

    private CompletableFuture<List<TableEntry>> get(DirectSegmentAccess segment, GetResultBuilder builder, Map<UUID, Long> bucketOffsets, TimeoutTimer timer) {
        TableBucketReader<TableEntry> bucketReader = TableBucketReader.entry(segment, this.keyIndex::getBackpointerOffset, this.executor);
        int resultSize = builder.getHashes().size();
        for (int i = 0; i < resultSize; ++i) {
            UUID keyHash = builder.getHashes().get(i);
            long offset = bucketOffsets.get(keyHash);
            if (offset == -1L) {
                builder.includeResult(CompletableFuture.completedFuture(null));
                continue;
            }
            ArrayView key = builder.getKeys().get(i);
            builder.includeResult((CompletableFuture<TableEntry>)Futures.exceptionallyExpecting(bucketReader.find(key, offset, timer), ex -> ex instanceof StreamSegmentTruncatedException, null).thenComposeAsync(entry -> {
                if (entry != null) {
                    return CompletableFuture.completedFuture(this.maybeDeleted((TableEntry)entry));
                }
                return ((CompletableFuture)this.keyIndex.getBucketOffsetDirect(segment, keyHash, timer).thenComposeAsync(newOffset -> bucketReader.find(key, (long)newOffset, timer), (Executor)this.executor)).thenApply(this::maybeDeleted);
            }, (Executor)this.executor));
        }
        return builder.getResultFutures();
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String segmentName, byte[] serializedState, Duration fetchTimeout) {
        this.logRequest("keyIterator", segmentName);
        return this.newIterator(segmentName, serializedState, fetchTimeout, TableBucketReader::key);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String segmentName, byte[] serializedState, Duration fetchTimeout) {
        this.logRequest("entryIterator", segmentName);
        return this.newIterator(segmentName, serializedState, fetchTimeout, TableBucketReader::entry);
    }

    @VisibleForTesting
    protected int getMaxCompactionSize() {
        return 0x400000;
    }

    private <T> TableKeyBatch batch(Collection<T> toBatch, Function<T, TableKey> getKey, Function<T, Integer> getLength, TableKeyBatch batch) {
        for (T item : toBatch) {
            Integer length = getLength.apply(item);
            TableKey key = getKey.apply(item);
            batch.add(key, this.hasher.hash(key.getKey()), length);
        }
        Preconditions.checkArgument((batch.getLength() <= 0x2000000 ? 1 : 0) != 0, (String)"Update Batch length (%s) exceeds the maximum limit.", (int)0x2000000);
        return batch;
    }

    private <T> CompletableFuture<Long> commit(Collection<T> toCommit, int serializationLength, BiConsumer<Collection<T>, byte[]> serializer, DirectSegmentAccess segment, Duration timeout) {
        assert (serializationLength <= 0x2000000);
        byte[] s = new byte[serializationLength];
        serializer.accept(toCommit, s);
        return segment.append((BufferView)new ByteArraySegment(s), null, timeout);
    }

    private <T> CompletableFuture<AsyncIterator<IteratorItem<T>>> newIterator(@NonNull String segmentName, byte[] serializedState, @NonNull Duration fetchTimeout, @NonNull GetBucketReader<T> createBucketReader) {
        UUID fromHash;
        if (segmentName == null) {
            throw new NullPointerException("segmentName is marked @NonNull but is null");
        }
        if (fetchTimeout == null) {
            throw new NullPointerException("fetchTimeout is marked @NonNull but is null");
        }
        if (createBucketReader == null) {
            throw new NullPointerException("createBucketReader is marked @NonNull but is null");
        }
        try {
            fromHash = KeyHasher.getNextHash(serializedState == null ? null : IteratorState.deserialize(serializedState).getKeyHash());
        }
        catch (IOException ex) {
            throw new IllegalDataFormatException("Unable to deserialize `serializedState`.", (Throwable)ex);
        }
        if (fromHash == null) {
            return CompletableFuture.completedFuture(TableIterator.empty());
        }
        return this.segmentContainer.forSegment(segmentName, fetchTimeout).thenComposeAsync(segment -> this.buildIterator((DirectSegmentAccess)segment, createBucketReader, fromHash, fetchTimeout), (Executor)this.executor);
    }

    private <T> CompletableFuture<AsyncIterator<IteratorItem<T>>> buildIterator(DirectSegmentAccess segment, GetBucketReader<T> createBucketReader, UUID fromHash, Duration fetchTimeout) {
        TableBucketReader bucketReader = createBucketReader.apply(segment, this.keyIndex::getBackpointerOffset, this.executor);
        TableIterator.ConvertResult converter = bucket -> bucketReader.findAllExisting(bucket.getSegmentOffset(), new TimeoutTimer(fetchTimeout)).thenApply(result -> new IteratorItemImpl(new IteratorState(bucket.getHash()), result));
        return this.keyIndex.getUnindexedKeyHashes(segment).thenComposeAsync(cacheHashes -> TableIterator.builder().segment(segment).cacheHashes((Map<UUID, CacheBucketOffset>)cacheHashes).firstHash(fromHash).executor(this.executor).resultConverter(converter).fetchTimeout(fetchTimeout).build(), (Executor)this.executor);
    }

    private TableEntry maybeDeleted(TableEntry e) {
        return e == null || e.getValue() == null ? null : e;
    }

    private void logRequest(String requestName, Object ... args) {
        log.debug("{}: {} {}", new Object[]{this.traceObjectId, requestName, args});
    }

    @FunctionalInterface
    private static interface GetBucketReader<T> {
        public TableBucketReader<T> apply(DirectSegmentAccess var1, TableBucketReader.GetBackpointer var2, ScheduledExecutorService var3);
    }

    private class IteratorItemImpl<T>
    implements IteratorItem<T> {
        private final IteratorState state;
        private final Collection<T> entries;

        public ArrayView getState() {
            return this.state.serialize();
        }

        public String toString() {
            return String.format("State = %s, EntryCount = %s", this.state, this.entries.size());
        }

        @ConstructorProperties(value={"state", "entries"})
        @SuppressFBWarnings(justification="generated code")
        public IteratorItemImpl(IteratorState state, Collection<T> entries) {
            this.state = state;
            this.entries = entries;
        }

        @SuppressFBWarnings(justification="generated code")
        public Collection<T> getEntries() {
            return this.entries;
        }
    }

    private static class GetResultBuilder {
        private final List<ArrayView> keys;
        private final List<UUID> hashes;
        private final List<CompletableFuture<TableEntry>> resultFutures;

        GetResultBuilder(List<ArrayView> keys, KeyHasher hasher) {
            this.keys = keys;
            this.hashes = keys.stream().map(hasher::hash).collect(Collectors.toList());
            this.resultFutures = new ArrayList<CompletableFuture<TableEntry>>();
        }

        void includeResult(CompletableFuture<TableEntry> entryFuture) {
            this.resultFutures.add(entryFuture);
        }

        CompletableFuture<List<TableEntry>> getResultFutures() {
            return Futures.allOfWithResults(this.resultFutures);
        }

        @SuppressFBWarnings(justification="generated code")
        public List<ArrayView> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<UUID> getHashes() {
            return this.hashes;
        }
    }

    private class TableWriterConnectorImpl
    implements TableWriterConnector {
        private final SegmentMetadata metadata;

        @Override
        public EntrySerializer getSerializer() {
            return ContainerTableExtensionImpl.this.serializer;
        }

        @Override
        public KeyHasher getKeyHasher() {
            return ContainerTableExtensionImpl.this.hasher;
        }

        @Override
        public CompletableFuture<DirectSegmentAccess> getSegment(Duration timeout) {
            return ContainerTableExtensionImpl.this.segmentContainer.forSegment(this.metadata.getName(), timeout);
        }

        @Override
        public void notifyIndexOffsetChanged(long lastIndexedOffset) {
            ContainerTableExtensionImpl.this.keyIndex.notifyIndexOffsetChanged(this.metadata.getId(), lastIndexedOffset);
        }

        @Override
        public int getMaxCompactionSize() {
            return ContainerTableExtensionImpl.this.getMaxCompactionSize();
        }

        @Override
        public void close() {
            ContainerTableExtensionImpl.this.keyIndex.notifyIndexOffsetChanged(this.metadata.getId(), -1L);
        }

        @ConstructorProperties(value={"metadata"})
        @SuppressFBWarnings(justification="generated code")
        public TableWriterConnectorImpl(SegmentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public SegmentMetadata getMetadata() {
            return this.metadata;
        }
    }
}

