/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import io.pravega.common.util.HashedArray;
import io.pravega.segmentstore.server.tables.BucketUpdate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class KeyUpdateCollection {
    private final Map<HashedArray, BucketUpdate.KeyUpdate> updates = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger totalUpdateCount = new AtomicInteger(0);
    private final AtomicLong lastIndexedOffset = new AtomicLong(-1L);
    private final AtomicLong highestCopiedOffset = new AtomicLong(Long.MIN_VALUE);

    KeyUpdateCollection() {
    }

    int getTotalUpdateCount() {
        return this.totalUpdateCount.get();
    }

    long getLastIndexedOffset() {
        return this.lastIndexedOffset.get();
    }

    long getHighestCopiedOffset() {
        return this.highestCopiedOffset.get();
    }

    void add(BucketUpdate.KeyUpdate update, int entryLength, long originalOffset) {
        BucketUpdate.KeyUpdate existing = this.updates.get(update.getKey());
        if (existing == null || update.supersedes(existing)) {
            this.updates.put(update.getKey(), update);
        }
        this.totalUpdateCount.incrementAndGet();
        long lastOffset = update.getOffset() + (long)entryLength;
        this.lastIndexedOffset.updateAndGet(e -> Math.max(lastOffset, e));
        if (originalOffset >= 0L) {
            this.highestCopiedOffset.updateAndGet(e -> Math.max(e, originalOffset + (long)entryLength));
        }
    }

    Collection<BucketUpdate.KeyUpdate> getUpdates() {
        return this.updates.values();
    }
}

