/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class TableKeyBatch {
    private final List<Item> items = new ArrayList<Item>();
    private final List<Item> versionedItems = new ArrayList<Item>();
    private final boolean removal;
    private int length;

    static TableKeyBatch update() {
        return new TableKeyBatch(false);
    }

    static TableKeyBatch removal() {
        return new TableKeyBatch(true);
    }

    void add(TableKey key, UUID hash, int length) {
        Item item = new Item(key, hash, this.length);
        this.items.add(item);
        this.length += length;
        if (key.hasVersion()) {
            this.versionedItems.add(item);
        }
    }

    boolean isConditional() {
        return this.versionedItems.size() > 0;
    }

    @SuppressFBWarnings(justification="generated code")
    public List<Item> getItems() {
        return this.items;
    }

    @SuppressFBWarnings(justification="generated code")
    public List<Item> getVersionedItems() {
        return this.versionedItems;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isRemoval() {
        return this.removal;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getLength() {
        return this.length;
    }

    @ConstructorProperties(value={"removal"})
    @SuppressFBWarnings(justification="generated code")
    private TableKeyBatch(boolean removal) {
        this.removal = removal;
    }

    static class Item {
        private final TableKey key;
        private final UUID hash;
        private final int offset;

        public String toString() {
            return String.format("Offset = %s, Hash = %s, Key = %s", this.offset, this.hash, this.key);
        }

        @ConstructorProperties(value={"key", "hash", "offset"})
        @SuppressFBWarnings(justification="generated code")
        private Item(TableKey key, UUID hash, int offset) {
            this.key = key;
            this.hash = hash;
            this.offset = offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public TableKey getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getHash() {
            return this.hash;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getOffset() {
            return this.offset;
        }
    }
}

