/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.Beta;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.store.SegmentContainerCollection;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Beta
public class TableService
extends SegmentContainerCollection
implements TableStore {
    public TableService(SegmentContainerRegistry segmentContainerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        super(segmentContainerRegistry, segmentToContainerMapper);
    }

    public CompletableFuture<Void> createSegment(String segmentName, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.createSegment(segmentName, timeout), "createSegment", segmentName);
    }

    public CompletableFuture<Void> deleteSegment(String segmentName, boolean mustBeEmpty, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.deleteSegment(segmentName, mustBeEmpty, timeout), "deleteSegment", segmentName, mustBeEmpty);
    }

    public CompletableFuture<Void> merge(String targetSegmentName, String sourceSegmentName, Duration timeout) {
        return this.invokeExtension(targetSegmentName, e -> e.merge(targetSegmentName, sourceSegmentName, timeout), "merge", targetSegmentName, sourceSegmentName);
    }

    public CompletableFuture<Void> seal(String segmentName, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.seal(segmentName, timeout), "seal", segmentName);
    }

    public CompletableFuture<List<Long>> put(String segmentName, List<TableEntry> entries, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.put(segmentName, entries, timeout), "put", segmentName, entries.size());
    }

    public CompletableFuture<Void> remove(String segmentName, Collection<TableKey> keys, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.remove(segmentName, keys, timeout), "remove", segmentName, keys.size());
    }

    public CompletableFuture<List<TableEntry>> get(String segmentName, List<ArrayView> keys, Duration timeout) {
        return this.invokeExtension(segmentName, e -> e.get(segmentName, keys, timeout), "get", segmentName, keys.size());
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String segmentName, byte[] serializedState, Duration fetchTimeout) {
        return this.invokeExtension(segmentName, e -> e.keyIterator(segmentName, serializedState, fetchTimeout), "get", segmentName, serializedState != null, fetchTimeout);
    }

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String segmentName, byte[] serializedState, Duration fetchTimeout) {
        return this.invokeExtension(segmentName, e -> e.entryIterator(segmentName, serializedState, fetchTimeout), "get", segmentName, serializedState != null, fetchTimeout);
    }

    private <T> CompletableFuture<T> invokeExtension(String streamSegmentName, Function<ContainerTableExtension, CompletableFuture<T>> toInvoke, String methodName, Object ... logArgs) {
        return super.invoke(streamSegmentName, segmentContainer -> (CompletableFuture)toInvoke.apply(segmentContainer.getExtension(ContainerTableExtension.class)), methodName, logArgs);
    }
}

