/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.OperationLog;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.Writer;
import io.pravega.segmentstore.server.WriterFactory;
import io.pravega.segmentstore.server.attributes.ContainerAttributeIndex;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.writer.StorageWriter;
import io.pravega.segmentstore.server.writer.WriterConfig;
import io.pravega.segmentstore.server.writer.WriterDataSource;
import io.pravega.segmentstore.storage.Storage;
import java.io.InputStream;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageWriterFactory
implements WriterFactory {
    private final WriterConfig config;
    private final ScheduledExecutorService executor;

    public StorageWriterFactory(WriterConfig config, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.config = config;
        this.executor = executor;
    }

    @Override
    public Writer createWriter(UpdateableContainerMetadata containerMetadata, OperationLog operationLog, ReadIndex readIndex, ContainerAttributeIndex attributeIndex, Storage storage, WriterFactory.CreateProcessors createProcessors) {
        Preconditions.checkArgument((containerMetadata.getContainerId() == operationLog.getId() ? 1 : 0) != 0, (Object)"Given containerMetadata and operationLog have different Container Ids.");
        StorageWriterDataSource dataSource = new StorageWriterDataSource(containerMetadata, operationLog, readIndex, attributeIndex);
        return new StorageWriter(this.config, dataSource, storage, createProcessors, this.executor);
    }

    private static class StorageWriterDataSource
    implements WriterDataSource {
        @SuppressFBWarnings(justification="generated code")
        private static final Logger log = LoggerFactory.getLogger(StorageWriterDataSource.class);
        private final UpdateableContainerMetadata containerMetadata;
        private final OperationLog operationLog;
        private final ReadIndex readIndex;
        private final ContainerAttributeIndex attributeIndex;
        private final String traceObjectId;

        StorageWriterDataSource(UpdateableContainerMetadata containerMetadata, OperationLog operationLog, ReadIndex readIndex, ContainerAttributeIndex attributeIndex) {
            this.containerMetadata = (UpdateableContainerMetadata)Preconditions.checkNotNull((Object)containerMetadata, (Object)"containerMetadata");
            this.operationLog = (OperationLog)Preconditions.checkNotNull((Object)operationLog, (Object)"operationLog");
            this.readIndex = (ReadIndex)Preconditions.checkNotNull((Object)readIndex, (Object)"readIndex");
            this.attributeIndex = (ContainerAttributeIndex)Preconditions.checkNotNull((Object)attributeIndex, (Object)"attributeIndex");
            this.traceObjectId = String.format("WriterDataSource[%d]", containerMetadata.getContainerId());
        }

        @Override
        public int getId() {
            return this.containerMetadata.getContainerId();
        }

        @Override
        public CompletableFuture<Void> acknowledge(long upToSequence, Duration timeout) {
            log.debug("{}: Acknowledge (UpToSeqNo={}).", (Object)this.traceObjectId, (Object)upToSequence);
            return this.operationLog.truncate(upToSequence, timeout);
        }

        @Override
        public CompletableFuture<Void> persistAttributes(long streamSegmentId, Map<UUID, Long> attributes, Duration timeout) {
            TimeoutTimer timer = new TimeoutTimer(timeout);
            return this.attributeIndex.forSegment(streamSegmentId, timer.getRemaining()).thenCompose(ai -> ai.update(attributes, timer.getRemaining()));
        }

        @Override
        public CompletableFuture<Void> sealAttributes(long streamSegmentId, Duration timeout) {
            TimeoutTimer timer = new TimeoutTimer(timeout);
            return this.attributeIndex.forSegment(streamSegmentId, timer.getRemaining()).thenCompose(ai -> ai.seal(timer.getRemaining()));
        }

        @Override
        public CompletableFuture<Void> deleteAllAttributes(SegmentMetadata segmentMetadata, Duration timeout) {
            return this.attributeIndex.delete(segmentMetadata.getName(), timeout);
        }

        @Override
        public CompletableFuture<Iterator<Operation>> read(long afterSequence, int maxCount, Duration timeout) {
            log.debug("{}: Read (AfterSeqNo={}, MaxCount={}).", new Object[]{this.traceObjectId, afterSequence, maxCount});
            return this.operationLog.read(afterSequence, maxCount, timeout);
        }

        @Override
        public void completeMerge(long targetStreamSegmentId, long sourceStreamSegmentId) throws StreamSegmentNotExistsException {
            log.debug("{}: CompleteMerge (TargetSegmentId={}, SourceSegmentId={}).", new Object[]{this.traceObjectId, targetStreamSegmentId, sourceStreamSegmentId});
            this.readIndex.completeMerge(targetStreamSegmentId, sourceStreamSegmentId);
        }

        @Override
        public boolean isValidTruncationPoint(long operationSequenceNumber) {
            return this.containerMetadata.isValidTruncationPoint(operationSequenceNumber);
        }

        @Override
        public long getClosestValidTruncationPoint(long operationSequenceNumber) {
            return this.containerMetadata.getClosestValidTruncationPoint(operationSequenceNumber);
        }

        @Override
        public UpdateableSegmentMetadata getStreamSegmentMetadata(long streamSegmentId) {
            return this.containerMetadata.getStreamSegmentMetadata(streamSegmentId);
        }

        @Override
        public InputStream getAppendData(long streamSegmentId, long startOffset, int length) {
            try {
                return this.readIndex.readDirect(streamSegmentId, startOffset, length);
            }
            catch (StreamSegmentNotExistsException ex) {
                return null;
            }
        }
    }
}

