/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import java.time.Duration;

public class WriterConfig {
    public static final Property<Integer> FLUSH_THRESHOLD_BYTES = Property.named((String)"flushThresholdBytes", (Object)0x400000);
    public static final Property<Long> FLUSH_THRESHOLD_MILLIS = Property.named((String)"flushThresholdMillis", (Object)30000L);
    public static final Property<Integer> MAX_FLUSH_SIZE_BYTES = Property.named((String)"maxFlushSizeBytes", (Object)FLUSH_THRESHOLD_BYTES.getDefaultValue());
    public static final Property<Integer> MAX_ITEMS_TO_READ_AT_ONCE = Property.named((String)"maxItemsToReadAtOnce", (Object)1000);
    public static final Property<Long> MIN_READ_TIMEOUT_MILLIS = Property.named((String)"minReadTimeoutMillis", (Object)2000L);
    public static final Property<Long> MAX_READ_TIMEOUT_MILLIS = Property.named((String)"maxReadTimeoutMillis", (Object)1800000L);
    public static final Property<Long> ERROR_SLEEP_MILLIS = Property.named((String)"errorSleepMillis", (Object)1000L);
    public static final Property<Long> FLUSH_TIMEOUT_MILLIS = Property.named((String)"flushTimeoutMillis", (Object)60000L);
    public static final Property<Long> ACK_TIMEOUT_MILLIS = Property.named((String)"ackTimeoutMillis", (Object)15000L);
    public static final Property<Long> SHUTDOWN_TIMEOUT_MILLIS = Property.named((String)"shutdownTimeoutMillis", (Object)10000L);
    public static final Property<Long> MAX_ROLLOVER_SIZE = Property.named((String)"maxRolloverSizeBytes", (Object)SegmentRollingPolicy.NO_ROLLING.getMaxLength());
    private static final String COMPONENT_CODE = "writer";
    private final int flushThresholdBytes;
    private final Duration flushThresholdTime;
    private final int maxFlushSizeBytes;
    private final int maxItemsToReadAtOnce;
    private final Duration minReadTimeout;
    private final Duration maxReadTimeout;
    private final Duration errorSleepDuration;
    private final Duration flushTimeout;
    private final Duration ackTimeout;
    private final Duration shutdownTimeout;
    private final long maxRolloverSize;

    private WriterConfig(TypedProperties properties) throws ConfigurationException {
        this.flushThresholdBytes = properties.getInt(FLUSH_THRESHOLD_BYTES);
        if (this.flushThresholdBytes < 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a non-negative integer.", FLUSH_THRESHOLD_BYTES));
        }
        this.flushThresholdTime = Duration.ofMillis(properties.getLong(FLUSH_THRESHOLD_MILLIS));
        this.maxFlushSizeBytes = properties.getInt(MAX_FLUSH_SIZE_BYTES);
        this.maxItemsToReadAtOnce = properties.getInt(MAX_ITEMS_TO_READ_AT_ONCE);
        if (this.maxItemsToReadAtOnce <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MAX_ITEMS_TO_READ_AT_ONCE));
        }
        long minReadTimeoutMillis = properties.getLong(MIN_READ_TIMEOUT_MILLIS);
        long maxReadTimeoutMillis = properties.getLong(MAX_READ_TIMEOUT_MILLIS);
        if (minReadTimeoutMillis < 0L) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer.", MIN_READ_TIMEOUT_MILLIS));
        }
        if (minReadTimeoutMillis > maxReadTimeoutMillis) {
            throw new ConfigurationException(String.format("Property '%s' must be smaller than or equal to '%s'.", MIN_READ_TIMEOUT_MILLIS, MAX_READ_TIMEOUT_MILLIS));
        }
        this.minReadTimeout = Duration.ofMillis(minReadTimeoutMillis);
        this.maxReadTimeout = Duration.ofMillis(maxReadTimeoutMillis);
        this.errorSleepDuration = Duration.ofMillis(properties.getLong(ERROR_SLEEP_MILLIS));
        this.flushTimeout = Duration.ofMillis(properties.getLong(FLUSH_TIMEOUT_MILLIS));
        this.ackTimeout = Duration.ofMillis(properties.getLong(ACK_TIMEOUT_MILLIS));
        this.shutdownTimeout = Duration.ofMillis(properties.getLong(SHUTDOWN_TIMEOUT_MILLIS));
        this.maxRolloverSize = Math.max(0L, properties.getLong(MAX_ROLLOVER_SIZE));
    }

    public static ConfigBuilder<WriterConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, WriterConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public int getFlushThresholdBytes() {
        return this.flushThresholdBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getFlushThresholdTime() {
        return this.flushThresholdTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxFlushSizeBytes() {
        return this.maxFlushSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxItemsToReadAtOnce() {
        return this.maxItemsToReadAtOnce;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getMinReadTimeout() {
        return this.minReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getMaxReadTimeout() {
        return this.maxReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getErrorSleepDuration() {
        return this.errorSleepDuration;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getFlushTimeout() {
        return this.flushTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getAckTimeout() {
        return this.ackTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getMaxRolloverSize() {
        return this.maxRolloverSize;
    }
}

